/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.protocol.listeners;

import org.mule.munit.common.protocol.message.TestStatus;

/**
 * Classes implementing this interface handle the notification of Suite/Test run.
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public interface SuiteRunEventListener {

  default void notifySuiteStart(String suite, String parameterization, int numberOfTests) {}

  default void notifyBeforeSuiteStart(String name) {}

  default void notifyBeforeSuiteEnd(String name, String stackTrace, TestStatus status) {}

  default void notifyTestStart(String name, String description, boolean ignored, String fileName) {}

  default void notifyTestEnd(String name, String stackTrace, TestStatus status, long elapsedTime, String fileName) {}

  default void notifyAfterSuiteStart(String name) {}

  default void notifyAfterSuiteEnd(String name, String stackTrace, TestStatus status) {}

  default void notifySuiteEnd(String suite, String parameterization, long elapsedTime) {}

  default void notifySuiteUnexpectedError(String name, String stackTrace) {}

}
