/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.mule.munit.common.util.ClassUtils;
import org.mule.munit.common.util.FileUtils;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.message.ds.ByteArrayDataSource;
import org.mule.runtime.core.api.message.ds.InputStreamDataSource;
import org.mule.runtime.core.api.message.ds.StringDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils
extends org.apache.commons.io.IOUtils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);

    public static URL getResourceAsUrl(String resourceName, Class callingClass) {
        return IOUtils.getResourceAsUrl(resourceName, callingClass, true, true);
    }

    public static URL getResourceAsUrl(String resourceName, Class callingClass, boolean tryAsFile, boolean tryAsUrl) {
        if (resourceName == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull((String)"Resource name").getMessage());
        }
        URL url = null;
        if (tryAsFile) {
            try {
                File file = FileUtils.newFile(resourceName);
                if (file.exists()) {
                    url = file.getAbsoluteFile().toURL();
                } else {
                    logger.debug("Unable to load resource from the file system: " + file.getAbsolutePath());
                }
            }
            catch (Exception e) {
                logger.debug("Unable to load resource from the file system: " + e.getMessage());
            }
        }
        if (url == null) {
            try {
                url = (URL)AccessController.doPrivileged(() -> ClassUtils.getResource(resourceName, callingClass));
                if (url == null) {
                    logger.debug("Unable to load resource " + resourceName + " from the classpath");
                }
            }
            catch (Exception e) {
                logger.debug("Unable to load resource " + resourceName + " from the classpath: " + e.getMessage());
            }
        }
        if (url == null) {
            try {
                url = new URL(resourceName);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    public static DataHandler toDataHandler(String name, Object object, MediaType contentType) throws IOException {
        DataHandler dh = object instanceof File ? (contentType != null ? new DataHandler((Object)new FileInputStream((File)object), contentType.toString()) : new DataHandler((DataSource)new FileDataSource((File)object))) : (object instanceof URL ? (contentType != null ? new DataHandler((Object)((URL)object).openStream(), contentType.toString()) : new DataHandler((URL)object)) : (object instanceof String ? (contentType != null ? new DataHandler((DataSource)new StringDataSource((String)object, name, contentType)) : new DataHandler((DataSource)new StringDataSource((String)object, name))) : (object instanceof byte[] && contentType != null ? new DataHandler((DataSource)new ByteArrayDataSource((byte[])object, contentType, name)) : (object instanceof InputStream && contentType != null ? new DataHandler((DataSource)new InputStreamDataSource((InputStream)object, contentType, name)) : new DataHandler(object, contentType.toString())))));
        return dh;
    }

    public static Properties toProperties(File propertiesFile) throws IOException {
        if (propertiesFile == null || !propertiesFile.exists()) {
            throw new IOException("Invalid or missing file: " + propertiesFile);
        }
        return IOUtils.toProperties(new FileInputStream(propertiesFile));
    }

    public static Properties toProperties(URL url) throws IOException {
        if (url == null) {
            throw new IOException("Invalid file URL!");
        }
        return IOUtils.toProperties(url.openStream());
    }

    private static Properties toProperties(InputStream stream) throws IOException {
        Properties properties = new Properties();
        properties.load(stream);
        return properties;
    }
}

