/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.assertion.internal.matchers;

import java.nio.charset.Charset;
import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.mule.munit.assertion.internal.matchers.TypedValueMatcher;
import org.mule.runtime.api.metadata.TypedValue;

public class EncodingMatcher
extends TypedValueMatcher {
    private Matcher nestedMatcher;

    public EncodingMatcher(Matcher nestedMatcher) {
        this.nestedMatcher = nestedMatcher;
    }

    @Override
    public boolean doMatch(TypedValue typedValue) {
        return this.nestedMatcher.matches((Object)this.getCharset(typedValue));
    }

    public void describeMismatch(Object item, Description description) {
        super.describeMismatch((Object)this.getCharset((TypedValue)item), description);
    }

    public void describeTo(Description description) {
        this.nestedMatcher.describeTo(description);
    }

    private Charset getCharset(TypedValue typedValue) {
        Optional charset = typedValue.getDataType().getMediaType().getCharset();
        return charset.isPresent() ? (Charset)charset.get() : null;
    }

    @Override
    public Matcher<Object> toPlainValueMatcher() {
        throw new IllegalStateException("Encoding Matcher cannot be compared to a value");
    }
}

