/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.assertion.api.expression;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MatcherResult {
    private boolean matches;
    private Description description;
    private List<String> reasons;

    public static Optional<MatcherResult> validateAndCreate(Map<String, Object> data) {
        block3: {
            block2: {
                if (data == null) break block2;
                if (Stream.of("matches", "description").allMatch(data::containsKey)) break block3;
            }
            return Optional.empty();
        }
        return Optional.of(new MatcherResult(data));
    }

    public MatcherResult() {
    }

    private MatcherResult(Map<String, Object> data) {
        this.matches = Boolean.TRUE.equals(data.get("matches"));
        this.description = new Description(data.get("description"));
        this.reasons = Optional.ofNullable(data.get("reasons")).filter(List.class::isInstance).map(values -> ((List)values).stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }

    public boolean isMatches() {
        return this.matches;
    }

    public void setMatches(boolean matches) {
        this.matches = matches;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public void setReasons(List<String> reasons) {
        this.reasons = reasons;
    }

    public Description getDescription() {
        return this.description;
    }

    public List<String> getReasons() {
        return this.reasons;
    }

    public String toString() {
        return "MatcherResult{matches=" + this.matches + ", description=" + this.description + ", reasons=" + this.reasons + '}';
    }

    public static class Description {
        private String expected;
        private String actual;
        private String message;

        private static String getStringOrNull(Object value) {
            return value instanceof String ? (String)value : null;
        }

        public Description() {
        }

        public Description(Object data) {
            if (data instanceof Map) {
                Map dataMap = (Map)data;
                this.expected = Description.getStringOrNull(dataMap.get("expected"));
                this.actual = Description.getStringOrNull(dataMap.get("actual"));
            } else {
                this.message = Description.getStringOrNull(data);
            }
        }

        public String getExpected() {
            return this.expected;
        }

        public void setExpected(String expected) {
            this.expected = expected;
        }

        public String getActual() {
            return this.actual;
        }

        public void setActual(String actual) {
            this.actual = actual;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String toString() {
            return "Description{expected='" + this.expected + '\'' + ", actual='" + this.actual + '\'' + ", message='" + this.message + '\'' + '}';
        }
    }
}

