/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.assertion.internal.matchers;



import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.mule.runtime.api.metadata.TypedValue;

/**
 * A TypedValueMatcher that uses a hamcrest matchers to perform an assertion over the value of a typed value
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class ValueMatcher extends TypedValueMatcher {

  private Matcher nestedMatcher;

  public ValueMatcher(Matcher nestedMatcher) {
    this.nestedMatcher = nestedMatcher;
  }

  @Override
  public boolean doMatch(TypedValue typedValue) {
    return nestedMatcher.matches(typedValue.getValue());
  }

  @Override
  public void describeMismatch(Object item, Description description) {
    super.describeMismatch(((TypedValue) item).getValue(), description);
  }

  @Override
  public void describeTo(Description description) {
    nestedMatcher.describeTo(description);
  }


  @Override
  public Matcher<Object> toPlainValueMatcher() {
    return new BaseMatcher<Object>() {

      @Override
      public void describeTo(Description description) {
        nestedMatcher.describeTo(description);
      }

      @Override
      public boolean matches(Object o) {
        return nestedMatcher.matches(o);
      }
    };
  }
}

