/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUtils {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String AUTHORIZATION = "Authorization";
    public static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientUtils.class);
    private static final String USER_AGENT_VERSION_PROPERTY_NAME = "user-agent.version";
    private static final String CONFIGURATION_PROPERTIES_FILE = "/anypoint-mq-rest-client.properties";
    private static Properties configuration;

    public static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkNotNull(Object argument, String message) {
        ClientUtils.checkArgument(argument != null, message);
    }

    public static String toString(InputStream inputStream) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = inputStream.read()) != -1) {
            sb.append((char)ch);
        }
        return sb.toString();
    }

    public static String getUserAgentVersion() {
        return ClientUtils.getConfiguration().getProperty(USER_AGENT_VERSION_PROPERTY_NAME);
    }

    public static String getUserAgent() {
        return "Mule Anypoint MQ/" + ClientUtils.getUserAgentVersion();
    }

    private static Properties getConfiguration() {
        if (configuration == null) {
            configuration = new Properties();
            try {
                configuration.load(ClientUtils.class.getResourceAsStream(CONFIGURATION_PROPERTIES_FILE));
            }
            catch (Exception e) {
                LOGGER.warn("Cannot read configuration file: " + ClientUtils.class.getResource(CONFIGURATION_PROPERTIES_FILE).getFile(), (Throwable)e);
                configuration = new Properties();
            }
        }
        return configuration;
    }

    public static boolean ofType(Throwable e, Class<? extends Throwable> type) {
        return e != null && type.isInstance(e);
    }

    public static boolean isTimeout(Throwable e) {
        return ClientUtils.ofType(e, TimeoutException.class);
    }

    public static boolean withMessage(Throwable e, String message) {
        return e.getMessage() != null && e.getMessage().contains(message);
    }

    public static boolean isConnectionInterrupted(Throwable e) {
        return ClientUtils.ofType(e, IOException.class) && ClientUtils.withMessage(e, "Remotely closed");
    }

    public static boolean isConnectionRefused(Throwable e) {
        return ClientUtils.ofType(e, ConnectException.class) && ClientUtils.withMessage(e, "Connection refused");
    }
}

