/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;

public class JsonUtils {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(InputStream.class, (Object)new TypeAdapter<InputStream>(){

        public void write(JsonWriter jsonWriter, InputStream inputStream) throws IOException {
            jsonWriter.value(IOUtils.toString((InputStream)inputStream, (Charset)AnypointMQMessage.DEFAULT_BODY_CHARSET));
        }

        public InputStream read(JsonReader jsonReader) throws IOException {
            return IOUtils.toInputStream((String)jsonReader.nextString(), (Charset)AnypointMQMessage.DEFAULT_BODY_CHARSET);
        }
    }).create();

    public static <T> T fromJson(String json, Type resultType) {
        return (T)GSON.fromJson(json, resultType);
    }

    public static String toJson(String ... entries) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < entries.length; i += 2) {
            map.put(entries[i], entries[i + 1]);
        }
        return JsonUtils.toJson(map);
    }

    public static <T> String toJson(T src) {
        return GSON.toJson(src);
    }

    protected static String toString(Object o) {
        return o != null ? o.toString() : null;
    }
}

