/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.api;

import com.google.common.base.Preconditions;
import com.mulesoft.mq.restclient.api.AnypointMqMessage;
import com.mulesoft.mq.restclient.internal.DefaultAnypointMqMessage;
import java.util.HashMap;
import java.util.Map;

public class AnypointMqMessageBuilder {
    private String body;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> properties = new HashMap<String, String>();

    public AnypointMqMessageBuilder withMessageId(String messageId) {
        this.addHeader("messageId", messageId);
        return this;
    }

    public AnypointMqMessageBuilder withLockId(String lockId) {
        this.addHeader("lockId", lockId);
        return this;
    }

    public AnypointMqMessageBuilder withBody(byte[] body) {
        this.body = body != null ? new String(body, AnypointMqMessage.DEFAULT_BODY_CHARSET) : null;
        return this;
    }

    public AnypointMqMessageBuilder withBody(String body) {
        this.body = body;
        return this;
    }

    public AnypointMqMessageBuilder addHeader(String name, String value) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Header name can not be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Header value can not be null");
        this.headers.put(name, value);
        return this;
    }

    public AnypointMqMessageBuilder addProperty(String name, String value) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Property name can not be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Property value can not be null");
        this.properties.put(name, value);
        return this;
    }

    public AnypointMqMessage build() {
        return new DefaultAnypointMqMessage(this.body, this.headers, this.properties);
    }
}

