/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.internal.dsl;

import com.mulesoft.mule.runtime.core.internal.config.scheduler.SchedulerPoolsArtifactConfig;
import javax.inject.Inject;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.scheduler.SchedulerPoolStrategy;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;

public class SchedulerPoolsArtifactConfigObjectFactory
extends AbstractComponentFactory<SchedulerPoolsArtifactConfig> {
    @Inject
    private MuleContext muleContext;
    private long gracefulShutdownTimeout;
    private SchedulerPoolStrategy poolStrategy;
    private SchedulerPoolsArtifactConfig.IoPoolConfig uberPoolConfig;
    private SchedulerPoolsArtifactConfig.CpuLightPoolConfig cpuLightPoolConfig;
    private SchedulerPoolsArtifactConfig.IoPoolConfig ioPoolConfig;
    private SchedulerPoolsArtifactConfig.CpuIntensivePoolConfig cpuIntensivePoolConfig;

    public SchedulerPoolsArtifactConfig doGetObject() throws Exception {
        if (this.poolStrategy == SchedulerPoolStrategy.UBER) {
            if (this.cpuLightPoolConfig != null || this.ioPoolConfig != null || this.cpuIntensivePoolConfig != null) {
                throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("cpuLight, cpuIntensive and io thread pools cannot be configured When the '%s' poolStrategy is selected", SchedulerPoolStrategy.UBER)));
            }
        } else if (this.poolStrategy == SchedulerPoolStrategy.DEDICATED) {
            if (this.uberPoolConfig != null) {
                throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("'%s' pool cannot be configured When the '%s' poolStrategy is selected", SchedulerPoolStrategy.UBER.name().toLowerCase(), SchedulerPoolStrategy.DEDICATED)));
            }
            if (this.cpuLightPoolConfig == null || this.ioPoolConfig == null || this.cpuIntensivePoolConfig == null) {
                throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("All three (cpuLight, cpuIntensive and io thread pools) must be configured When the '%s' poolStrategy is selected", SchedulerPoolStrategy.DEDICATED)));
            }
        } else {
            throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)("Unsupported pool strategy type: " + this.poolStrategy)));
        }
        return new SchedulerPoolsArtifactConfig(this.muleContext.getConfiguration().getId(), this.gracefulShutdownTimeout, this.poolStrategy, this.uberPoolConfig, this.cpuLightPoolConfig, this.ioPoolConfig, this.cpuIntensivePoolConfig);
    }

    public long getGracefulShutdownTimeout() {
        return this.gracefulShutdownTimeout;
    }

    public void setGracefulShutdownTimeout(long gracefulShutdownTimeout) {
        this.gracefulShutdownTimeout = gracefulShutdownTimeout;
    }

    public SchedulerPoolStrategy getPoolStrategy() {
        return this.poolStrategy;
    }

    public void setPoolStrategy(SchedulerPoolStrategy poolStrategy) {
        this.poolStrategy = poolStrategy;
    }

    public SchedulerPoolsArtifactConfig.IoPoolConfig getUberPoolConfig() {
        return this.uberPoolConfig;
    }

    public void setUberPoolConfig(SchedulerPoolsArtifactConfig.IoPoolConfig uberPoolConfig) {
        this.uberPoolConfig = uberPoolConfig;
    }

    public SchedulerPoolsArtifactConfig.CpuLightPoolConfig getCpuLightPoolConfig() {
        return this.cpuLightPoolConfig;
    }

    public void setCpuLightPoolConfig(SchedulerPoolsArtifactConfig.CpuLightPoolConfig cpuLightPoolConfig) {
        this.cpuLightPoolConfig = cpuLightPoolConfig;
    }

    public SchedulerPoolsArtifactConfig.IoPoolConfig getIoPoolConfig() {
        return this.ioPoolConfig;
    }

    public void setIoPoolConfig(SchedulerPoolsArtifactConfig.IoPoolConfig ioPoolConfig) {
        this.ioPoolConfig = ioPoolConfig;
    }

    public SchedulerPoolsArtifactConfig.CpuIntensivePoolConfig getCpuIntensivePoolConfig() {
        return this.cpuIntensivePoolConfig;
    }

    public void setCpuIntensivePoolConfig(SchedulerPoolsArtifactConfig.CpuIntensivePoolConfig cpuIntensivePoolConfig) {
        this.cpuIntensivePoolConfig = cpuIntensivePoolConfig;
    }
}

