/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.plugin.factory;

import com.mulesoft.mule.runtime.module.plugin.api.MulePlugin;
import com.mulesoft.mule.runtime.plugin.PluginProperty;
import com.mulesoft.mule.runtime.plugin.factory.PluginPropertyDescriptor;
import com.mulesoft.mule.runtime.plugin.factory.PluginPropertyDiscoverer;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.BeanWrapperImpl;

public class MulePluginPropertyDiscoverer
implements PluginPropertyDiscoverer {
    private final MulePlugin plugin;

    public MulePluginPropertyDiscoverer(MulePlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public List<PluginPropertyDescriptor> discoverProperties() {
        LinkedList<PluginPropertyDescriptor> properties = new LinkedList<PluginPropertyDescriptor>();
        for (Class<?> aClass = this.plugin.getClass(); aClass != Object.class; aClass = aClass.getSuperclass()) {
            for (Field field : aClass.getDeclaredFields()) {
                PluginProperty annotation = field.getAnnotation(PluginProperty.class);
                if (annotation == null) continue;
                PluginPropertyDescriptor propertyDescriptor = new PluginPropertyDescriptor();
                propertyDescriptor.setName(field.getName());
                propertyDescriptor.setDescription(annotation.description());
                propertyDescriptor.setValue(this.getPropertyValue(this.plugin, propertyDescriptor.getName()));
                properties.add(propertyDescriptor);
            }
        }
        return properties;
    }

    private String getPropertyValue(MulePlugin plugin, String name) {
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl((Object)plugin);
        Object propertyValue = beanWrapper.getPropertyValue(name);
        if (propertyValue == null) {
            return null;
        }
        return propertyValue.toString();
    }
}

