/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;

public class MuleArraysAsListSerializer
extends Serializer<List<?>> {
    public List<?> read(Kryo kryo, Input input, Class<List<?>> type) {
        int length = input.readInt(true);
        Class<?> componentType = this.readComponentType(kryo, input);
        try {
            Object items = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                Array.set(items, i, kryo.readClassAndObject(input));
            }
            return Arrays.asList((Object[])items);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> readComponentType(Kryo kryo, Input input) {
        Registration registration = kryo.readClass(input);
        if (registration == null || registration.getType() == null) {
            return Object.class;
        }
        Class componentType = registration.getType();
        if (componentType.isPrimitive()) {
            return MuleArraysAsListSerializer.getPrimitiveWrapperClass(componentType);
        }
        return componentType;
    }

    public void write(Kryo kryo, Output output, List<?> obj) {
        try {
            int length = obj.size();
            output.writeInt(length, true);
            kryo.writeClass(output, null);
            for (Object item : obj) {
                kryo.writeClassAndObject(output, item);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<?> copy(Kryo kryo, List<?> original) {
        try {
            Object[] array = original.toArray();
            kryo.reference((Object)array);
            Object[] arrayCopy = (Object[])kryo.copy((Object)array);
            return Arrays.asList(arrayCopy);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> getPrimitiveWrapperClass(Class<?> c) {
        if (c.isPrimitive()) {
            if (c.equals(Long.TYPE)) {
                return Long.class;
            }
            if (c.equals(Integer.TYPE)) {
                return Integer.class;
            }
            if (c.equals(Double.TYPE)) {
                return Double.class;
            }
            if (c.equals(Float.TYPE)) {
                return Float.class;
            }
            if (c.equals(Boolean.TYPE)) {
                return Boolean.class;
            }
            if (c.equals(Character.TYPE)) {
                return Character.class;
            }
            if (c.equals(Short.TYPE)) {
                return Short.class;
            }
            if (c.equals(Byte.TYPE)) {
                return Byte.class;
            }
        }
        return c;
    }
}

