/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.Field;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.internal.message.DefaultMessageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessageBuilderSerializer
extends Serializer<DefaultMessageBuilder> {
    public static final String PARSING_ERROR_MESSAGE = "Couldn't parse instance of DefaultMessageBuilder";
    private static final String PAYLOAD = "payload";
    private static final String ATTRIBUTES = "attributes";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMessageBuilderSerializer.class);

    public void write(Kryo kryo, Output output, DefaultMessageBuilder message) {
        try {
            Field attributesField = DefaultMessageBuilder.class.getDeclaredField(ATTRIBUTES);
            Field payloadField = DefaultMessageBuilder.class.getDeclaredField(PAYLOAD);
            attributesField.setAccessible(true);
            payloadField.setAccessible(true);
            kryo.writeObjectOrNull(output, attributesField.get(message), TypedValue.class);
            kryo.writeObjectOrNull(output, payloadField.get(message), TypedValue.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Error occurred: ", e);
        }
    }

    public DefaultMessageBuilder read(Kryo kryo, Input input, Class<DefaultMessageBuilder> type) {
        TypedValue attributes = (TypedValue)kryo.readObjectOrNull(input, TypedValue.class);
        if (this.checkPropertiesAndAttachments(input)) {
            this.parseAttachmentsAndProperties(kryo, input);
        }
        TypedValue payload = (TypedValue)kryo.readObjectOrNull(input, TypedValue.class);
        return (DefaultMessageBuilder)new DefaultMessageBuilder().attributes(attributes).payload(payload);
    }

    private boolean checkPropertiesAndAttachments(Input input) {
        boolean result = false;
        try {
            Input buffer = new Input(input.getBuffer());
            buffer.setPosition(input.position());
            int remaining = buffer.limit() - buffer.position();
            if (remaining == 0) {
                result = input.readVarInt(true) != 1;
                input.setPosition(0);
            } else {
                result = buffer.readVarInt(true) != 1;
            }
        }
        catch (KryoException e) {
            LOGGER.debug("Failed to read value length.");
            result = true;
        }
        return result;
    }

    private void parseAttachmentsAndProperties(Kryo kryo, Input input) {
        for (int i = 0; i < 4; ++i) {
            kryo.readClassAndObject(input);
        }
    }
}

