/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.vm;

import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionalQueue;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastTimeoutUtils;
import com.mulesoft.mule.runtime.module.cluster.internal.serialization.SerializationSaavyTransactionalQueue;
import com.mulesoft.mule.runtime.module.cluster.internal.vm.ClusterQueueNameResolver;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.core.internal.util.queue.QueueStore;
import org.mule.runtime.core.internal.util.queue.QueueTransactionContext;

public class HazelcastQueueTransactionContext
implements QueueTransactionContext {
    public static final int LONG_TIMEOUT = 10000;
    public static final int SHORT_TIMEOUT = 10;
    private final TransactionContext transactionContext;
    private final ClusterQueueNameResolver clusterQueueNameResolver;
    private final ObjectSerializer objectSerializer;

    public HazelcastQueueTransactionContext(TransactionContext transactionContext, ClusterQueueNameResolver clusterQueueNameResolver, ObjectSerializer objectSerializer) {
        this.transactionContext = transactionContext;
        this.clusterQueueNameResolver = clusterQueueNameResolver;
        this.objectSerializer = objectSerializer;
    }

    public boolean offer(QueueStore queue, Serializable item, long offerTimeout) throws InterruptedException {
        return HazelcastTimeoutUtils.executeWithTimeoutIntervals(offerTimeout, t -> this.getClusterQueue(queue).offer((Object)item, t.longValue(), TimeUnit.MILLISECONDS), result -> result);
    }

    public void untake(QueueStore queue, Serializable item) throws InterruptedException {
        this.offer(queue, item, 10000L);
    }

    public void clear(QueueStore queue) throws InterruptedException {
        while (this.getClusterQueue(queue).poll(10L, TimeUnit.MILLISECONDS) != null) {
        }
    }

    public Serializable poll(QueueStore queue, long pollTimeout) throws InterruptedException {
        return HazelcastTimeoutUtils.executeWithTimeoutIntervals(pollTimeout, t -> (Serializable)this.getClusterQueue(queue).poll(t.longValue(), TimeUnit.MILLISECONDS), Objects::nonNull);
    }

    public Serializable peek(QueueStore queue) {
        return (Serializable)this.getClusterQueue(queue).peek();
    }

    public int size(QueueStore queue) {
        return this.getClusterQueue(queue).size();
    }

    private TransactionalQueue<Object> getClusterQueue(QueueStore queue) {
        TransactionalQueue transactionalQueue = this.transactionContext.getQueue(this.clusterQueueNameResolver.resolveQueueName(queue.getName()));
        return new SerializationSaavyTransactionalQueue<Object>(transactionalQueue, this.objectSerializer);
    }
}

