/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.security;

import javax.crypto.spec.SecretKeySpec;
import org.mule.encryption.Encrypter;
import org.mule.encryption.jce.JCEEncrypter;
import org.mule.encryption.key.EncryptionKeyFactory;
import org.mule.encryption.key.SymmetricKeyFactory;

public class NodeSecurityManager {
    public static final String PROPERTY_SECURITY_MODEL = "mule.security.model";
    public static final String FIPS_SECURITY_MODEL = "fips140-2";
    boolean isFipsEnabled = "fips140-2".equals(System.getProperty("mule.security.model"));
    private String key = System.getProperty("mule.cluster.network.encryption.key", null);

    public boolean isFipsEnabled() {
        if (this.key == null && this.isFipsEnabled) {
            throw new IllegalArgumentException("Cluster key must be defined in FIPS mode. Define the mule.cluster.network.encryption.key property");
        }
        return this.isFipsEnabled || this.key != null;
    }

    public synchronized Encrypter getEncrypter() {
        if (this.key == null || !this.isFipsEnabled) {
            throw new IllegalArgumentException("Cluster key should be defined and FIPS mode must be enabled. Define the mule.cluster.network.encryption.key property");
        }
        SymmetricKeyFactory keyFactory = () -> new SecretKeySpec(this.key.getBytes(), "Blowfish");
        JCEEncrypter encrypter = new JCEEncrypter("Blowfish/CBC/PKCS5Padding", (EncryptionKeyFactory)keyFactory);
        return encrypter;
    }

    public void setFipsEnabled(boolean fipsEnabled) {
        this.isFipsEnabled = fipsEnabled;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

