/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.cache.internal.keygenerator;

import com.mulesoft.mule.runtime.cache.api.key.MuleEventKeyGenerator;
import java.security.MessageDigest;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHA256MuleEventKeyGenerator
implements MuleEventKeyGenerator,
MuleContextAware {
    private static final Logger logger = LoggerFactory.getLogger(SHA256MuleEventKeyGenerator.class);
    private MuleContext muleContext;

    @Override
    public String generateKey(CoreEvent event) {
        try {
            byte[] bytesOfMessage = ((PrivilegedEvent)event).getMessageAsBytes(this.muleContext);
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            String key = StringUtils.toHexString((byte[])md.digest(bytesOfMessage));
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Generated key for event: %s key: %s", event, key));
            }
            return key;
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

