/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.bti.internal.jdbc;

import com.mulesoft.mule.runtime.bti.internal.jdbc.BitronixXaDataSourceBuilder;
import com.mulesoft.mule.runtime.bti.internal.jdbc.BitronixXaDataSourceWrapper;
import com.mulesoft.mule.runtime.bti.internal.transaction.TransactionManagerWrapper;
import java.util.Optional;
import javax.inject.Inject;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.mule.runtime.api.config.DatabasePoolingProfile;
import org.mule.runtime.api.tx.DataSourceDecorator;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitronixDatabaseDecorator
implements DataSourceDecorator {
    private static final Logger logger = LoggerFactory.getLogger(BitronixDatabaseDecorator.class);
    @Inject
    private MuleConfiguration muleConfiguration;
    @Inject
    private Optional<TransactionManager> txManager;

    public DataSource decorate(DataSource dataSource, String dataSourceName, DatabasePoolingProfile dbPoolingProfile) {
        Preconditions.checkState((boolean)this.appliesTo(dataSource), (String)"BitronixDatabaseDecorator.decorate should not be invoked if the decorator should not be applied to the DataSource");
        logger.info(String.format("No pool defined for XADataSource in connector %s. A default pool will be created. To customize define a bti:xa-data-source-pool element in your config and assign it to the connector.", dataSource));
        BitronixXaDataSourceBuilder builder = new BitronixXaDataSourceBuilder();
        builder.setName(dataSourceName);
        builder.setDataSource((XADataSource)((Object)dataSource));
        if (dbPoolingProfile != null) {
            builder.setMaxPoolSize(dbPoolingProfile.getMaxPoolSize());
            builder.setMinPoolSize(dbPoolingProfile.getMinPoolSize());
            builder.setAcquireIncrement(dbPoolingProfile.getAcquireIncrement());
            builder.setAcquisitionTimeoutSeconds(this.getAcquisitionTimeoutSeconds(dbPoolingProfile));
            builder.setPreparedStatementCacheSize(dbPoolingProfile.getPreparedStatementCacheSize());
        }
        return builder.build(this.muleConfiguration, this.txManager.orElse(null));
    }

    public boolean appliesTo(DataSource dataSource) {
        return dataSource instanceof XADataSource && !(dataSource instanceof BitronixXaDataSourceWrapper) && this.txManager.orElse(null) instanceof TransactionManagerWrapper;
    }

    private int getAcquisitionTimeoutSeconds(DatabasePoolingProfile dbPoolingProfile) {
        Long timeOutSeconds = dbPoolingProfile.getMaxWaitUnit().toSeconds(dbPoolingProfile.getMaxWait());
        if (dbPoolingProfile.getMaxWait() > 0 && timeOutSeconds == 0L) {
            timeOutSeconds = 1L;
        }
        return timeOutSeconds.intValue();
    }
}

