/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.bti.internal.transaction;

import com.mulesoft.mule.runtime.bti.api.transaction.MuleTransactionManager;
import com.mulesoft.mule.runtime.bti.internal.transaction.TransactionWrapper;
import com.mulesoft.mule.runtime.bti.internal.transaction.XaResourceList;
import com.mulesoft.mule.runtime.bti.internal.xa.QueueManagerXaResourceProducer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAResource;

public class TransactionManagerWrapper
implements MuleTransactionManager,
UserTransaction {
    private final Supplier<? extends TransactionManager> delegateSupplier;
    private final QueueManagerXaResourceProducer xaSessionResourceProducer;
    private final ThreadLocal<XaResourceList> xaResourceThreadLocal = new ThreadLocal();
    private final ThreadLocal<Deque<XaResourceList>> suspendedXaResourceThreadLocal = new ThreadLocal();
    private final ConcurrentHashMap<Transaction, TransactionWrapper> wrappedTransactions = new ConcurrentHashMap();

    public TransactionManagerWrapper(Supplier<? extends TransactionManager> transactionManagerSupplier, QueueManagerXaResourceProducer xaSessionResourceProducer) {
        this.delegateSupplier = transactionManagerSupplier;
        this.xaSessionResourceProducer = xaSessionResourceProducer;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.delegateSupplier.get().begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        Transaction transaction = this.delegateSupplier.get().getTransaction();
        try {
            this.delegateSupplier.get().commit();
        }
        finally {
            if (transaction != null) {
                this.wrappedTransactions.remove(transaction);
            }
            this.removeStoredDefaultXaSessions();
        }
    }

    public int getStatus() throws SystemException {
        return this.delegateSupplier.get().getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        Transaction transaction = this.delegateSupplier.get().getTransaction();
        if (transaction != null) {
            TransactionWrapper wrappedTransaction = new TransactionWrapper(transaction, this);
            TransactionWrapper originalWrappedTransaction = this.wrappedTransactions.putIfAbsent(transaction, wrappedTransaction);
            if (originalWrappedTransaction != null) {
                wrappedTransaction = originalWrappedTransaction;
            }
            return wrappedTransaction;
        }
        return null;
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        Deque<XaResourceList> deque = this.suspendedXaResourceThreadLocal.get();
        if (deque != null) {
            this.xaResourceThreadLocal.set(deque.pop());
        }
        this.delegateSupplier.get().resume(transaction);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        Transaction transaction = null;
        try {
            transaction = this.delegateSupplier.get().getTransaction();
            this.delegateSupplier.get().rollback();
        }
        finally {
            this.removeStoredDefaultXaSessions();
            if (transaction != null) {
                this.wrappedTransactions.remove(transaction);
            }
        }
    }

    private void removeStoredDefaultXaSessions() {
        XaResourceList xaResources = this.xaResourceThreadLocal.get();
        if (xaResources != null) {
            xaResources.removeFromQueueManager(this.xaSessionResourceProducer);
            this.xaResourceThreadLocal.remove();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.delegateSupplier.get().setRollbackOnly();
    }

    public void setTransactionTimeout(int i) throws SystemException {
        this.delegateSupplier.get().setTransactionTimeout(i);
    }

    public Transaction suspend() throws SystemException {
        XaResourceList xaResources = this.xaResourceThreadLocal.get();
        if (xaResources != null) {
            Deque<XaResourceList> suspendedXaResources = this.suspendedXaResourceThreadLocal.get();
            if (suspendedXaResources == null) {
                suspendedXaResources = new ArrayDeque<XaResourceList>();
                this.suspendedXaResourceThreadLocal.set(suspendedXaResources);
            }
            suspendedXaResources.push(xaResources);
            this.xaResourceThreadLocal.set(new XaResourceList());
        }
        return this.delegateSupplier.get().suspend();
    }

    public void setCurrentXaResource(XAResource xaResource) {
        XaResourceList xaResources = this.xaResourceThreadLocal.get();
        if (xaResources == null) {
            xaResources = new XaResourceList();
            this.xaResourceThreadLocal.set(xaResources);
        }
        xaResources.add(xaResource);
        this.xaSessionResourceProducer.addXaResource(xaResource);
    }
}

