/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.bti.internal.transaction;

import com.mulesoft.mule.runtime.bti.internal.transaction.TransactionManagerWrapper;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import javax.transaction.xa.XAResource;

public class TransactionWrapper
implements Transaction {
    private final Transaction delegate;
    private final TransactionManagerWrapper transactionalManagerWrapper;

    public TransactionWrapper(Transaction transaction, TransactionManagerWrapper transactionManagerWrapper) {
        this.delegate = transaction;
        this.transactionalManagerWrapper = transactionManagerWrapper;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.delegate.commit();
    }

    public boolean delistResource(XAResource xaResource, int i) throws IllegalStateException, SystemException {
        return this.delegate.delistResource(xaResource, i);
    }

    public boolean enlistResource(XAResource xaResource) throws RollbackException, IllegalStateException, SystemException {
        this.transactionalManagerWrapper.setCurrentXaResource(xaResource);
        return this.delegate.enlistResource(xaResource);
    }

    public int getStatus() throws SystemException {
        return this.delegate.getStatus();
    }

    public void registerSynchronization(Synchronization synchronization) throws RollbackException, IllegalStateException, SystemException {
        this.delegate.registerSynchronization(synchronization);
    }

    public void rollback() throws IllegalStateException, SystemException {
        this.delegate.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.clearInterruptedFlag();
        this.delegate.setRollbackOnly();
    }

    private void clearInterruptedFlag() {
        Thread.interrupted();
    }
}

