/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.bti.internal.messaging;

import com.mulesoft.mule.runtime.bti.api.messaging.ConnectionFactoryDecorator;
import com.mulesoft.mule.runtime.bti.api.messaging.MessagingConnectionConfig;
import com.mulesoft.mule.runtime.bti.internal.messaging.XAConnectionFactoryWrapper;
import jakarta.inject.Inject;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.XAConnectionFactory;
import jakarta.transaction.TransactionManager;
import org.mule.runtime.core.api.config.MuleConfiguration;

public abstract class AbstractConnectionFactoryDecorator
implements ConnectionFactoryDecorator {
    private MuleConfiguration muleConfiguration;
    private TransactionManager txManager;

    @Override
    public ConnectionFactory decorate(ConnectionFactory connectionFactory, MessagingConnectionConfig messagingConfig) {
        if (!this.appliesTo(connectionFactory)) {
            throw new IllegalStateException("DefaultConnectionFactoryDecorator invoked but it shouldn't be called since it does not applies to the ConnectionFactory");
        }
        return this.doDecorate(connectionFactory, messagingConfig, this.muleConfiguration, this.txManager);
    }

    protected abstract ConnectionFactory doDecorate(ConnectionFactory var1, MessagingConnectionConfig var2, MuleConfiguration var3, TransactionManager var4);

    protected boolean isXaConnectionFactory(ConnectionFactory connectionFactory) {
        return connectionFactory instanceof XAConnectionFactory;
    }

    protected boolean isConnectionFactoryWrapper(ConnectionFactory connectionFactory) {
        return connectionFactory instanceof XAConnectionFactoryWrapper;
    }

    @Inject
    public void setMuleConfiguration(MuleConfiguration muleConfiguration) {
        this.muleConfiguration = muleConfiguration;
    }

    @Inject
    public void setTxManager(TransactionManager txManager) {
        this.txManager = txManager;
    }

    protected TransactionManager getTxManager() {
        return this.txManager;
    }
}

