/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.reboot;

import com.mulesoft.licm.EnterpriseLicenseKey;
import com.mulesoft.licm.LicenseKeyException;
import com.mulesoft.licm.LicenseManagementFactory;
import com.mulesoft.licm.LicenseManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LicenseKeyHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseKeyHandler.class);
    private static EnterpriseLicenseKey KEY = null;
    public static final String LICENSE_FILE_NAME = "muleLicenseKey.lic";
    private LicenseManager licenseManager;
    private File licenseLocation;

    public static EnterpriseLicenseKey getKey() {
        return KEY;
    }

    public LicenseKeyHandler() {
        try {
            this.licenseManager = LicenseManagementFactory.getInstance().createLicenseManager("mule-ee");
        }
        catch (LicenseKeyException e) {
            LOGGER.error("Error creating License Manager!", (Throwable)e);
            throw new IllegalStateException();
        }
    }

    public EnterpriseLicenseKey install(EnterpriseLicenseKey key) throws LicenseKeyException {
        try {
            this.licenseManager.unInstall();
            this.licenseManager.install(key);
            EnterpriseLicenseKey installedKey = this.licenseManager.validate("mule-ee");
            this.licenseLocation = this.lookupMuleBaseConf();
            this.moveLicenseKeyFileToMuleBaseConf();
            File licenseKeyFile = new File(key.getLicenseKeyFile());
            licenseKeyFile.delete();
            return installedKey;
        }
        catch (LicenseKeyException e) {
            LOGGER.error("Couldn't install license key!", (Throwable)e);
            throw e;
        }
    }

    public void unInstall() throws LicenseKeyException {
        try {
            this.licenseManager.unInstall();
        }
        catch (LicenseKeyException e) {
            LOGGER.error("Couldn't uninstall license key!", (Throwable)e);
            throw e;
        }
    }

    public synchronized EnterpriseLicenseKey validate() throws LicenseKeyException {
        if (KEY != null) {
            return KEY;
        }
        EnterpriseLicenseKey key = null;
        try {
            key = this.licenseManager.validate("mule-ee");
            if (key.isEvaluation()) {
                this.licenseLocation = this.lookupMuleBaseConf();
                this.moveLicenseKeyFileToMuleBaseConf();
            }
        }
        catch (LicenseKeyException e) {
            System.out.println("Couldn't validate license key. Please contact Mulesoft Support, support@mulesoft.com, to renew your license.");
        }
        KEY = key;
        return key;
    }

    private void moveLicenseKeyFileToMuleBaseConf() {
        File target;
        boolean success;
        File file;
        URL licenseUrl = Thread.currentThread().getContextClassLoader().getResource(LICENSE_FILE_NAME);
        if (licenseUrl == null && (file = new File(LICENSE_FILE_NAME)).exists() && !(success = file.renameTo(target = new File(this.licenseLocation, LICENSE_FILE_NAME)))) {
            try {
                Files.copy(file.toPath(), target.toPath(), new CopyOption[0]);
                file.delete();
            }
            catch (Exception e) {
                LOGGER.debug("Couldn't move license file from: " + file.getAbsolutePath() + "to: " + target.getAbsolutePath());
            }
        }
    }

    private File lookupMuleBaseConf() {
        File muleHome = null;
        String muleHomeVar = System.getProperty("mule.home");
        if (muleHomeVar != null && !muleHomeVar.trim().equals("") && !muleHomeVar.equals("%MULE_HOME%")) {
            try {
                muleHome = new File(muleHomeVar).getCanonicalFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Problem with mule.home!");
            }
        }
        if (muleHome == null || !muleHome.exists() || !muleHome.isDirectory()) {
            throw new IllegalArgumentException("Either MULE_HOME is not set or does not contain a valid directory.");
        }
        File muleBase = null;
        File muleBaseConf = null;
        String muleBaseVar = System.getProperty("mule.base");
        if (muleBaseVar != null && !muleBaseVar.trim().equals("") && !muleBaseVar.equals("%MULE_BASE%")) {
            try {
                muleBase = new File(muleBaseVar).getCanonicalFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Problem with mule.home!");
            }
        }
        if (muleBase == null) {
            muleBase = muleHome;
        }
        muleBaseConf = new File(muleBase, "conf");
        return muleBaseConf;
    }
}

