/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.reboot;

import com.mulesoft.licm.EnterpriseLicenseKey;
import com.mulesoft.licm.LicenseKeyException;
import com.mulesoft.licm.LicenseManagementFactory;
import com.mulesoft.licm.impl.MuleLicenseInterrupter;
import com.mulesoft.mule.runtime.core.api.license.MuleLicenseUtils;
import com.mulesoft.mule.runtime.module.reboot.LicenseKeyHandler;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.commons.cli.CommandLine;
import org.mule.runtime.module.boot.internal.BootstrapConfigurationException;
import org.mule.runtime.module.boot.internal.BootstrapConfigurer;

public class LicenseCheckBootstrapConfigurer
implements BootstrapConfigurer {
    private static final CompletableFuture<EnterpriseLicenseKey> LICENSE_VALIDATION = new CompletableFuture();
    private final String testingModePropertyName;
    private final CommandLine commandLine;
    private volatile boolean disposeRequested = false;

    public LicenseCheckBootstrapConfigurer(String testingModePropertyName, CommandLine commandLine) {
        this.testingModePropertyName = testingModePropertyName;
        this.commandLine = commandLine;
    }

    public boolean configure() throws BootstrapConfigurationException {
        try {
            return this.handleLicenseKey(this.commandLine);
        }
        catch (Exception e) {
            throw new BootstrapConfigurationException(1, (Throwable)e);
        }
    }

    public void await() throws BootstrapConfigurationException {
        if (this.isTestingMode()) {
            return;
        }
        while (!this.disposeRequested) {
            try {
                LICENSE_VALIDATION.get();
                return;
            }
            catch (ExecutionException e) {
                throw new BootstrapConfigurationException(1, e.getCause());
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void dispose() {
        this.disposeRequested = true;
        LICENSE_VALIDATION.cancel(true);
        MuleLicenseInterrupter.dispose();
    }

    private boolean handleLicenseKey(CommandLine commandLine) throws LicenseKeyException, IOException {
        Supplier<LicenseKeyHandler> licenseKeyHandler = LicenseKeyHandler::new;
        if (commandLine.hasOption("installLicense")) {
            String keyRequestFile = commandLine.getOptionValue("installLicense");
            File keyRequest = new File(keyRequestFile);
            if (!keyRequest.exists()) {
                throw new IOException("License key file - " + keyRequestFile + " not found!");
            }
            EnterpriseLicenseKey key = LicenseManagementFactory.getInstance().createLicenseKey("mule-ee");
            key.setLicenseKeyFile(keyRequestFile);
            EnterpriseLicenseKey newKey = licenseKeyHandler.get().install(key);
            System.out.println();
            System.out.println("Installed license key.");
            System.out.println(newKey);
            System.out.println();
            return false;
        }
        if (commandLine.hasOption("unInstallLicense")) {
            licenseKeyHandler.get().unInstall();
            System.out.println();
            System.out.println("Uninstalled license key.");
            System.out.println();
            return false;
        }
        if (commandLine.hasOption("verifyLicense")) {
            System.out.println();
            System.out.println("Valid license key --> " + licenseKeyHandler.get().validate());
            System.out.println();
            return false;
        }
        this.validateLicense(licenseKeyHandler);
        return true;
    }

    private void validateLicense(Supplier<LicenseKeyHandler> licenseKeyHandler) {
        new Thread(() -> this.doValidateLicense(licenseKeyHandler)).start();
    }

    private void doValidateLicense(Supplier<LicenseKeyHandler> licenseKeyHandler) {
        try {
            EnterpriseLicenseKey key = licenseKeyHandler.get().validate();
            if (key != null) {
                if (this.isTestingMode()) {
                    MuleLicenseUtils.setIsBypassLicenseCheck(true);
                    System.out.println();
                    System.out.println("Running Mule in testing mode");
                    System.out.println();
                } else {
                    MuleLicenseUtils.setIsBypassLicenseCheck(key.isEvaluation());
                    System.out.println();
                    System.out.println("Valid license key --> " + key);
                    System.out.println();
                }
                LICENSE_VALIDATION.complete(key);
            } else {
                LICENSE_VALIDATION.completeExceptionally(new LicenseKeyException());
            }
        }
        catch (Exception e) {
            LICENSE_VALIDATION.completeExceptionally(e);
        }
    }

    private boolean isTestingMode() {
        return System.getProperty(this.testingModePropertyName) != null;
    }
}

