/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal;

import com.mulesoft.mule.runtime.module.batch.api.BatchJob;
import com.mulesoft.mule.runtime.module.batch.api.BatchStep;
import com.mulesoft.mule.runtime.module.batch.internal.ImmutableBatchStep;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ImmutableBatchJob
implements BatchJob,
Serializable {
    private static final long serialVersionUID = -5630147014411534L;
    private final String name;
    private final List<BatchStep> steps;
    private final int maxFailedRecords;

    public static List<BatchJob> forCollection(Collection<BatchJob> jobs) {
        if (jobs == null || jobs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BatchJob> immutables = new ArrayList<BatchJob>(jobs.size());
        for (BatchJob job : jobs) {
            immutables.add(new ImmutableBatchJob(job));
        }
        return immutables;
    }

    public ImmutableBatchJob(BatchJob job) {
        this.name = job.getName();
        this.maxFailedRecords = job.getMaxFailedRecords();
        List<BatchStep> originalSteps = job.getSteps();
        this.steps = new ArrayList<BatchStep>(originalSteps.size());
        for (BatchStep step : originalSteps) {
            this.steps.add(new ImmutableBatchStep(step));
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public List<BatchStep> getSteps() {
        return this.steps;
    }

    @Override
    public int getMaxFailedRecords() {
        return this.maxFailedRecords;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImmutableBatchJob) {
            return this.name.equals(((ImmutableBatchJob)obj).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

