/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine.buffer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchJobInstance;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.engine.BatchEngine;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.BatchStepAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.queue.BatchQueueDelegate;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContext;
import com.mulesoft.mule.runtime.module.batch.internal.engine.buffer.AbstractStreamingAggregatorQueueBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class StreamingAggregatorInputQueueBuffer
extends AbstractStreamingAggregatorQueueBuffer {
    private final LoadingCache<String, AtomicLong> flushedRecordsCount = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, AtomicLong>(){

        public AtomicLong load(String key) throws Exception {
            return new AtomicLong(0L);
        }
    });

    public StreamingAggregatorInputQueueBuffer(BatchEngine batchEngine, BatchStepAdapter step) {
        super(String.format("batch-step-%s-streaming-aggregator-input-queue-buffer", step.getName()), batchEngine, step);
    }

    @Override
    protected BatchQueueDelegate getDelegate(BatchJobInstanceAdapter jobInstance) {
        return this.batchQueueManager.streamingAggregatorInputQueue(jobInstance, this.step);
    }

    public long getFlushedRecordCount(BatchJobInstance jobInstance) {
        return this.getFlushedRecordsCount(jobInstance).get();
    }

    @Override
    protected void doFlush(BatchJobInstanceAdapter jobInstance, BatchTransactionContext ctx, List<Record> records) {
        super.doFlush(jobInstance, ctx, records);
        records.forEach(r -> r.getCompletionCallback().decrementConsumers());
        this.getFlushedRecordsCount(jobInstance).addAndGet(records.size());
    }

    @Override
    protected void doForget(BatchJobInstanceAdapter jobInstance) {
        super.doForget(jobInstance);
        this.flushedRecordsCount.invalidate((Object)jobInstance.getId());
    }

    private AtomicLong getFlushedRecordsCount(BatchJobInstance jobInstance) {
        return (AtomicLong)this.flushedRecordsCount.getUnchecked((Object)jobInstance.getId());
    }
}

