/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine.buffer;

import com.google.common.collect.ImmutableList;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.engine.BatchEngine;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.MuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchContextTransactionRecorder {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchContextTransactionRecorder.class);
    private BatchEngine batchEngine;
    private TransactionContextRecordsInfo transactionContextRecordsInfo = new TransactionContextRecordsInfo();

    public BatchContextTransactionRecorder(BatchEngine batchEngine) {
        this.batchEngine = batchEngine;
    }

    public synchronized void tryFlush(BatchTransactionContext ctx, List<Record> records) throws MuleException {
        List<Record> ctxRecords;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Attempting to flush %s records for job instance '%s", records.size(), ctx.getJobInstance().getId()));
        }
        if ((ctxRecords = this.transactionContextRecordsInfo.addRecords(ctx, records)).size() >= ctx.getBlockSize()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Flushing %s records for job instance '%s", ctxRecords.size(), ctx.getJobInstance().getId()));
            }
            this.batchEngine.updateStatisticsAndRoute(ctx, ctxRecords);
            this.transactionContextRecordsInfo.remove(ctx);
        }
    }

    public synchronized Integer size(BatchJobInstanceAdapter jobInstance) {
        return this.transactionContextRecordsInfo.size(jobInstance);
    }

    public synchronized void flushAndForget(BatchJobInstanceAdapter jobInstance) throws MuleException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Flushing all records for job instance '%s", jobInstance.getId()));
        }
        for (Map.Entry<BatchTransactionContext, List<Record>> entry : this.transactionContextRecordsInfo.getTransactionContextInfo(jobInstance)) {
            this.batchEngine.updateStatisticsAndRoute(entry.getKey(), (List<Record>)ImmutableList.copyOf((Collection)entry.getValue()));
            this.transactionContextRecordsInfo.remove(jobInstance);
        }
    }

    private static class TransactionContextRecordsInfo {
        private Map<BatchTransactionContext, List<Record>> recordsPerTransactionContext = new HashMap<BatchTransactionContext, List<Record>>();
        private Map<BatchJobInstanceAdapter, Integer> sizePerJobInstance = new HashMap<BatchJobInstanceAdapter, Integer>();

        private TransactionContextRecordsInfo() {
        }

        public List<Record> addRecords(BatchTransactionContext ctx, List<Record> records) {
            List cxtRecords = this.recordsPerTransactionContext.computeIfAbsent(ctx, key -> new ArrayList());
            cxtRecords.addAll(records);
            this.sizePerJobInstance.putIfAbsent(ctx.getJobInstance(), 0);
            this.sizePerJobInstance.put(ctx.getJobInstance(), this.sizePerJobInstance.get(ctx.getJobInstance()) + records.size());
            return cxtRecords;
        }

        public void remove(BatchJobInstanceAdapter jobInstance) {
            this.recordsPerTransactionContext.keySet().removeIf(key -> key.getJobInstance().equals(jobInstance));
            this.sizePerJobInstance.remove(jobInstance);
        }

        public void remove(BatchTransactionContext ctx) {
            List<Record> ctxRecords = this.recordsPerTransactionContext.remove(ctx);
            if (ctxRecords != null) {
                this.sizePerJobInstance.put(ctx.getJobInstance(), this.sizePerJobInstance.get(ctx.getJobInstance()) - ctxRecords.size());
            }
        }

        public int size(BatchJobInstanceAdapter jobInstance) {
            return this.sizePerJobInstance.getOrDefault(jobInstance, 0);
        }

        public Set<Map.Entry<BatchTransactionContext, List<Record>>> getTransactionContextInfo(BatchJobInstanceAdapter jobInstance) {
            return this.recordsPerTransactionContext.entrySet().stream().filter(entry -> ((BatchTransactionContext)entry.getKey()).getJobInstance().equals(jobInstance)).collect(Collectors.toSet());
        }
    }
}

