/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.reboot.license;

import com.mulesoft.mule.runtime.module.reboot.DefaultFipsSecurityManager;
import com.mulesoft.mule.runtime.module.reboot.license.LicenseProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BouncyCastleProviderScope
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BouncyCastleProviderScope.class);
    private Provider[] originalProviders = null;

    private BouncyCastleProviderScope() {
    }

    public static BouncyCastleProviderScope createWithInjectedProviders() throws LicenseProviderException {
        BouncyCastleProviderScope scope = new BouncyCastleProviderScope();
        try {
            scope.injectAllNecessaryProviders();
            return scope;
        }
        catch (Exception e) {
            try {
                scope.close();
            }
            catch (Exception closeException) {
                LOGGER.warn("Failed to cleanup scope after injection failure", (Throwable)closeException);
            }
            throw e;
        }
    }

    public static boolean isBcAvailable() {
        try {
            DefaultFipsSecurityManager.createFipsProvider();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void injectAllNecessaryProviders() throws LicenseProviderException {
        if (!Objects.isNull(this.originalProviders)) {
            LOGGER.debug("Providers already injected, skipping injection");
            return;
        }
        try {
            this.originalProviders = Security.getProviders();
            if (BouncyCastleProviderScope.isBcAvailable()) {
                Provider fipsProvider = DefaultFipsSecurityManager.createFipsProvider();
                Security.insertProviderAt(fipsProvider, 1);
                Provider jsseProvider = DefaultFipsSecurityManager.createJsseProvider();
                Security.insertProviderAt(jsseProvider, 2);
                LOGGER.debug("Injected FIPS providers for license verification");
            } else {
                LOGGER.warn("FIPS libraries not available, using existing providers");
            }
        }
        catch (Exception e) {
            throw new LicenseProviderException("Failed to inject security providers: " + e.getMessage(), e);
        }
    }

    @Override
    public void close() throws LicenseProviderException {
        this.restoreOriginalProviders();
    }

    public void restoreOriginalProviders() throws LicenseProviderException {
        if (this.originalProviders == null) {
            LOGGER.debug("No original providers saved, nothing to restore");
            return;
        }
        try {
            for (Provider provider : Security.getProviders()) {
                Security.removeProvider(provider.getName());
            }
            for (int i = 0; i < this.originalProviders.length; ++i) {
                Security.insertProviderAt(this.originalProviders[i], i + 1);
            }
            LOGGER.debug("Restored {} original providers", (Object)this.originalProviders.length);
            this.originalProviders = null;
        }
        catch (Exception e) {
            throw new LicenseProviderException("Failed to restore original providers: " + e.getMessage(), e);
        }
    }
}

