/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.wss.internal.util;

import com.google.common.collect.ImmutableMap;
import com.mulesoft.modules.wss.api.constants.SoapVersion;
import com.mulesoft.modules.wss.internal.error.WssException;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public final class SoapMessageHandler {
    private static final Map<SoapVersion, MessageFactory> factories = ImmutableMap.of((Object)((Object)SoapVersion.SOAP_11), (Object)SoapMessageHandler.factoryFor("SOAP 1.1 Protocol"), (Object)((Object)SoapVersion.SOAP_12), (Object)SoapMessageHandler.factoryFor("SOAP 1.2 Protocol"));
    private static final String invalidInputMessage = "Unable to obtain SOAP request from payload";

    private static MessageFactory factoryFor(String protocol) {
        try {
            return MessageFactory.newInstance((String)protocol);
        }
        catch (SOAPException e) {
            throw new WssException("Error creating SOAP MESSAGE Factory for protocol: " + protocol, (Exception)((Object)e));
        }
    }

    public SOAPMessage create(InputStream request, String contentType, SoapVersion version) {
        try {
            MessageFactory factory = factories.get((Object)version);
            if (factory == null) {
                throw new WssException("Invalid SOAP Version [" + String.valueOf((Object)version) + "]");
            }
            MimeHeaders headers = new MimeHeaders();
            headers.addHeader("Content-Type", contentType);
            SOAPMessage soapMessage = factory.createMessage(headers, request);
            if (soapMessage.getSOAPPart().getDocumentElement() == null) {
                throw new WssException(invalidInputMessage);
            }
            return soapMessage;
        }
        catch (SOAPException | IOException e) {
            throw new WssException(invalidInputMessage, (Exception)e);
        }
    }

    public InputStream serialize(SOAPMessage message) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            message.writeTo((OutputStream)out);
            return new ByteArrayInputStream(out.toByteArray());
        }
        catch (Exception e) {
            throw new WssException("Error while serializing result SOAP MESSAGE", e);
        }
    }
}

