/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.wss.api.outbound;

import com.mulesoft.modules.wss.api.constants.EncryptionDigestAlgorithmConstants;
import com.mulesoft.modules.wss.api.constants.EncryptionKeyIdentifierConstants;
import com.mulesoft.modules.wss.api.constants.EncryptionKeyTransportAlgorithmConstants;
import com.mulesoft.modules.wss.api.constants.EncryptionSymAlgorithmConstants;
import com.mulesoft.modules.wss.api.outbound.BaseOutboundConfig;
import com.mulesoft.modules.wss.api.store.KeyStoreConfiguration;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class EncryptionConfig
extends BaseOutboundConfig {
    @Parameter
    @Optional(defaultValue="ISSUER_SERIAL")
    @Summary(value="The key identifier type to use for encryption.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private EncryptionKeyIdentifierConstants encryptionKeyIdentifier;
    @Parameter
    @Optional(defaultValue="AES_128")
    @Summary(value="The symmetric encryption algorithm to use.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private EncryptionSymAlgorithmConstants encryptionSymAlgorithm;
    @Parameter
    @Optional(defaultValue="KEYTRANSPORT_RSAOAEP")
    @Summary(value="The algorithm used to encrypt the generated symmetric key.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private EncryptionKeyTransportAlgorithmConstants encryptionKeyTransportAlgorithm;
    @Parameter
    @Optional
    @Summary(value="The encryption digest algorithm to use with the key transport algorithm.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private EncryptionDigestAlgorithmConstants encryptionDigestAlgorithm;
    @Parameter
    @Optional
    @DisplayName(value="KeyStore Configuration")
    @Summary(value="KeyStore configuration used for encryption.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Alias(value="keystore-config")
    private KeyStoreConfiguration keyStoreConfiguration;

    public EncryptionKeyIdentifierConstants getEncryptionKeyIdentifier() {
        return this.encryptionKeyIdentifier;
    }

    public EncryptionSymAlgorithmConstants getEncryptionSymAlgorithm() {
        return this.encryptionSymAlgorithm;
    }

    public EncryptionKeyTransportAlgorithmConstants getEncryptionKeyTransportAlgorithm() {
        return this.encryptionKeyTransportAlgorithm;
    }

    public EncryptionDigestAlgorithmConstants getEncryptionDigestAlgorithm() {
        return this.encryptionDigestAlgorithm;
    }

    public KeyStoreConfiguration getKeyStoreConfiguration() {
        return this.keyStoreConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptionConfig that = (EncryptionConfig)o;
        return this.encryptionKeyIdentifier == that.encryptionKeyIdentifier && this.encryptionSymAlgorithm == that.encryptionSymAlgorithm && this.encryptionKeyTransportAlgorithm == that.encryptionKeyTransportAlgorithm && this.encryptionDigestAlgorithm == that.encryptionDigestAlgorithm && Objects.equals(this.keyStoreConfiguration, that.keyStoreConfiguration);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.encryptionKeyIdentifier, this.encryptionSymAlgorithm, this.encryptionKeyTransportAlgorithm, this.encryptionDigestAlgorithm, this.keyStoreConfiguration});
    }
}

