/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.wss.internal.outbound;

import com.mulesoft.modules.wss.api.outbound.EncryptionConfig;
import com.mulesoft.modules.wss.api.outbound.SignatureConfig;
import com.mulesoft.modules.wss.api.outbound.TimestampConfig;
import com.mulesoft.modules.wss.internal.outbound.WssOutboundOperations;
import java.util.concurrent.TimeUnit;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;

@Operations(value={WssOutboundOperations.class})
@Configuration(name="outbound")
public class WssOutboundConfig
implements Initialisable {
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @DisplayName(value="Signature Configuration")
    private SignatureConfig signatureConfig;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @DisplayName(value="Encryption Configuration")
    private EncryptionConfig encryptionConfig;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @DisplayName(value="Timestamp Configuration")
    private TimestampConfig outboundTimestampConfig;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="'Must Understand' Attribute")
    private boolean mustUnderstand;

    public void initialise() throws InitialisationException {
        WSSConfig.init();
        if (this.getEncryptionConfig() == null && this.getSignatureConfig() == null && this.getOutboundTimestampConfig() == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"No WSS config was found in config, at least one is required"), (Initialisable)this);
        }
        if (this.getOutboundTimestampConfig() != null && TimeUnit.SECONDS.convert(this.getOutboundTimestampConfig().getTimeToLive().longValue(), this.getOutboundTimestampConfig().getTimeUnit()) > Integer.MAX_VALUE) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Time to live configuration value exceeds limit"), (Initialisable)this);
        }
    }

    public SignatureConfig getSignatureConfig() {
        return this.signatureConfig;
    }

    public boolean getMustUnderstand() {
        return this.mustUnderstand;
    }

    public EncryptionConfig getEncryptionConfig() {
        return this.encryptionConfig;
    }

    public TimestampConfig getOutboundTimestampConfig() {
        return this.outboundTimestampConfig;
    }
}

