/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.wss.internal.inbound;

import com.mulesoft.modules.wss.api.inbound.DecryptionConfig;
import com.mulesoft.modules.wss.api.inbound.VerifySamlConfig;
import com.mulesoft.modules.wss.api.inbound.VerifySignatureConfig;
import com.mulesoft.modules.wss.api.inbound.VerifyTimestampConfig;
import com.mulesoft.modules.wss.api.inbound.VerifyUsernameTokenConfig;
import com.mulesoft.modules.wss.internal.error.WssException;
import com.mulesoft.modules.wss.internal.error.WssSecurityException;
import com.mulesoft.modules.wss.internal.handler.CredentialsCallbackHandler;
import com.mulesoft.modules.wss.internal.handler.InboundConfigHandler;
import com.mulesoft.modules.wss.internal.inbound.NullProcessor;
import com.mulesoft.modules.wss.internal.inbound.WssInboundOperations;
import com.mulesoft.modules.wss.internal.security.SoapWssSecurityProvider;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.api.security.SecurityProvider;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.w3c.dom.Document;

@Operations(value={WssInboundOperations.class})
@Configuration(name="inbound")
public class WssInboundConfig
implements Initialisable,
Disposable {
    @Inject
    @Named(value="_muleSecurityManager")
    private SecurityManager securityManager;
    @Parameter
    @Optional
    private String actor;
    @Optional
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean extractSecurityHeader;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @DisplayName(value="Validate Username Token")
    @Placement(tab="Validation")
    private VerifyUsernameTokenConfig usernameConfig;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @DisplayName(value="Validate Signature")
    @Placement(tab="Validation")
    private VerifySignatureConfig verifySignatureConfig;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @DisplayName(value="Decrypt Message")
    @Placement(tab="Decryption")
    private DecryptionConfig decryptionConfig;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @DisplayName(value="Validate Timestamp")
    @Placement(tab="Validation")
    private VerifyTimestampConfig timestampConfig;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @DisplayName(value="Validate SAML Assertion")
    @Placement(tab="SAML")
    private VerifySamlConfig verifySamlConfig;
    private WSSecurityEngine engine;
    private RequestData requestData;
    private ArrayList<Integer> requiredValidations;

    public void initialise() throws InitialisationException {
        this.validateConfig();
        this.doSetUpSecurityProvider();
        this.doSetUpEngine();
    }

    private void doSetUpSecurityProvider() throws InitialisationException {
        SecurityProvider provider = this.securityManager.getProvider(SoapWssSecurityProvider.ID);
        if (provider == null) {
            SoapWssSecurityProvider securityProvider = new SoapWssSecurityProvider();
            securityProvider.initialise();
            this.securityManager.addProvider((SecurityProvider)securityProvider);
        }
    }

    private void validateConfig() throws InitialisationException {
        if (this.verifySignatureConfig == null && this.decryptionConfig == null && this.timestampConfig == null && this.usernameConfig == null && this.verifySamlConfig == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"No WSS config was found in config, at least one is required"), (Initialisable)this);
        }
    }

    private void doSetUpEngine() throws InitialisationException {
        WSSecurityEngine engine = new WSSecurityEngine();
        WSSConfig wssConfig = engine.getWssConfig();
        this.initConfig(wssConfig);
        RequestData data = new RequestData();
        data.setCallbackHandler((CallbackHandler)new CredentialsCallbackHandler());
        try {
            this.handleInboundConfig(wssConfig, data);
            data.setAllowRSA15KeyTransportAlgorithm(true);
            data.setActor(this.actor);
            data.setWssConfig(wssConfig);
            this.requestData = data;
            this.engine = engine;
        }
        catch (WssException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    private void handleInboundConfig(WSSConfig wssConfig, RequestData data) {
        InboundConfigHandler handler = new InboundConfigHandler(wssConfig, data);
        this.requiredValidations = new ArrayList();
        if (this.verifySignatureConfig != null) {
            handler.handle(this.verifySignatureConfig);
            this.requiredValidations.add(2);
        }
        if (this.decryptionConfig != null) {
            handler.handle(this.decryptionConfig);
            this.requiredValidations.add(4);
        }
        if (this.timestampConfig != null) {
            handler.handle(this.timestampConfig);
            this.requiredValidations.add(32);
        }
        if (this.usernameConfig != null) {
            handler.handle(this.usernameConfig);
            this.requiredValidations.add(1);
        }
        if (this.verifySamlConfig != null) {
            handler.handle(this.verifySamlConfig);
            this.requiredValidations.add(16);
        }
    }

    private void validateResult(WSHandlerResult result) throws WSSecurityException {
        for (Integer validation : this.requiredValidations) {
            if (result.getActionResults().containsKey(validation) || validation == 16 && result.getActionResults().containsKey(8) || validation == 2 && result.getActionResults().containsKey(16)) continue;
            throw new WSSecurityException(WSSecurityException.ErrorCode.SECURITY_ERROR);
        }
    }

    private void initConfig(WSSConfig wssConfig) {
        wssConfig.setProcessor(WSConstants.SAML_TOKEN, NullProcessor.class);
        wssConfig.setProcessor(WSConstants.SAML2_TOKEN, NullProcessor.class);
        wssConfig.setProcessor(WSConstants.SIGNATURE, NullProcessor.class);
        wssConfig.setProcessor(WSConstants.TIMESTAMP, NullProcessor.class);
        wssConfig.setProcessor(WSConstants.USERNAME_TOKEN, NullProcessor.class);
        wssConfig.setProcessor(WSConstants.ENCRYPTED_KEY, NullProcessor.class);
    }

    public String getActor() {
        return this.actor;
    }

    public boolean extractSecurityHeader() {
        return this.extractSecurityHeader;
    }

    public void dispose() {
        this.engine = null;
    }

    public synchronized WSHandlerResult processSecurity(Document envelope) {
        try {
            WSHandlerResult result = this.engine.processSecurityHeader(envelope, this.requestData);
            this.validateResult(result);
            return result;
        }
        catch (WSSecurityException e) {
            throw new WssSecurityException("Error processing security: " + e.getMessage(), (Exception)((Object)e));
        }
    }
}

