/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.wss.internal.inbound;

import com.mulesoft.modules.wss.internal.error.WssSecurityException;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.UsernameToken;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.Validator;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;

public class LDAPValidator
implements Validator {
    private LdapAuthenticationProvider authenticationProvider;

    public LDAPValidator(LdapAuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        try {
            UsernameToken usernameToken = credential.getUsernametoken();
            if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText".equals(usernameToken.getPasswordType())) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
            }
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)usernameToken.getName(), (Object)usernameToken.getPassword());
            if (!this.authenticationProvider.authenticate((Authentication)token).isAuthenticated()) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
            }
            return credential;
        }
        catch (WssSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, e);
        }
    }
}

