/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.wss.internal.handler;

import com.mulesoft.modules.wss.api.constants.SamlConfirmationMethod;
import com.mulesoft.modules.wss.api.inbound.AuthenticateUserConfig;
import com.mulesoft.modules.wss.api.inbound.CredentialsConfig;
import com.mulesoft.modules.wss.api.inbound.DecryptionConfig;
import com.mulesoft.modules.wss.api.inbound.LDAPConfig;
import com.mulesoft.modules.wss.api.inbound.VerifySamlConfig;
import com.mulesoft.modules.wss.api.inbound.VerifySignatureConfig;
import com.mulesoft.modules.wss.api.inbound.VerifyTimestampConfig;
import com.mulesoft.modules.wss.api.inbound.VerifyUsernameTokenConfig;
import com.mulesoft.modules.wss.api.store.KeyStoreConfiguration;
import com.mulesoft.modules.wss.internal.error.MissingCertificateException;
import com.mulesoft.modules.wss.internal.error.WssException;
import com.mulesoft.modules.wss.internal.handler.CredentialsCallbackHandler;
import com.mulesoft.modules.wss.internal.handler.StoreConfigHandler;
import com.mulesoft.modules.wss.internal.inbound.LDAPValidator;
import com.mulesoft.modules.wss.internal.inbound.SamlValidator;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.processor.EncryptedKeyProcessor;
import org.apache.wss4j.dom.processor.SAMLTokenProcessor;
import org.apache.wss4j.dom.processor.SignatureProcessor;
import org.apache.wss4j.dom.processor.TimestampProcessor;
import org.apache.wss4j.dom.processor.UsernameTokenProcessor;
import org.apache.wss4j.dom.validate.UsernameTokenValidator;
import org.apache.wss4j.dom.validate.Validator;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;

public class InboundConfigHandler {
    private final WSSConfig wssConfig;
    private final RequestData requestData;

    public InboundConfigHandler(WSSConfig wssConfig, RequestData requestData) {
        this.wssConfig = wssConfig;
        this.requestData = requestData;
    }

    public void handle(VerifySignatureConfig signatureConfig) {
        try {
            Merlin merlin = new Merlin(StoreConfigHandler.getWssProperties(signatureConfig.getTrustStoreConfig()), this.getClass().getClassLoader(), null);
            this.requestData.setSigVerCrypto((Crypto)merlin);
            this.wssConfig.setProcessor(WSConstants.SIGNATURE, SignatureProcessor.class);
            if (signatureConfig.getSubjectPattern() != null) {
                this.requestData.setSubjectCertConstraints(Collections.singletonList(Pattern.compile(signatureConfig.getSubjectPattern())));
            }
            if (signatureConfig.getIssuerPattern() != null) {
                this.requestData.setIssuerDNPatterns(Collections.singletonList(Pattern.compile(signatureConfig.getIssuerPattern())));
            }
        }
        catch (WSSecurityException e) {
            throw new WssException("Error setting signature validation configuration: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MissingCertificateException("Unable to get certificate from TrustStore.", e);
        }
    }

    public void handle(DecryptionConfig decryptionConfig) {
        try {
            KeyStoreConfiguration keyStoreConfig = decryptionConfig.getKeyStoreConfig();
            CredentialsCallbackHandler cch = (CredentialsCallbackHandler)this.requestData.getCallbackHandler();
            cch.setDecryptionConfigCredentials(new CredentialsConfig(keyStoreConfig.getAlias(), keyStoreConfig.getKeyPassword()));
            this.requestData.setDecCrypto((Crypto)new Merlin(StoreConfigHandler.getWssProperties(keyStoreConfig), this.getClass().getClassLoader(), null));
            this.wssConfig.setProcessor(WSConstants.ENCRYPTED_KEY, EncryptedKeyProcessor.class);
        }
        catch (WSSecurityException e) {
            throw new WssException("Error setting decrypt configuration: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MissingCertificateException("Unable to get certificate from Key Store.", e);
        }
    }

    public void handle(VerifyTimestampConfig timestampConfig) {
        this.requestData.setTimeStampTTL((int)timestampConfig.getTimeUnit().convert(timestampConfig.getTimeToLive().intValue(), TimeUnit.SECONDS));
        this.requestData.setTimeStampStrict(timestampConfig.isStrict());
        this.requestData.setTimeStampFutureTTL((int)timestampConfig.getTimeUnit().convert(timestampConfig.getSkewTime().intValue(), TimeUnit.SECONDS));
        this.requestData.setRequireTimestampExpires(timestampConfig.isRequireExpiresHeader());
        this.requestData.setPrecisionInMilliSeconds(timestampConfig.isPrecisionInMilliseconds());
        this.wssConfig.setProcessor(WSConstants.TIMESTAMP, TimestampProcessor.class);
    }

    public void handle(VerifySamlConfig samlConfig) {
        TimeUnit timeUnit = samlConfig.getTimeUnit();
        SamlValidator samlAssertionValidator = new SamlValidator(this.requestData);
        samlAssertionValidator.setTtl((int)timeUnit.convert(samlConfig.getTimeToLive().intValue(), TimeUnit.SECONDS));
        samlAssertionValidator.setFutureTTL((int)timeUnit.convert(samlConfig.getSkewTime().intValue(), TimeUnit.SECONDS));
        samlAssertionValidator.setValidateSignatureAgainstProfile(samlConfig.isValidateSignatureAgainstProfile());
        samlAssertionValidator.setRequireStandardSubjectConfirmationMethod(samlConfig.isRequireStandardSubjectConfirmationMethod());
        samlAssertionValidator.setRequireBearerSignature(samlConfig.isRequireBearerSignature());
        SamlConfirmationMethod method = samlConfig.getRequiredSubjectConfirmationMethod();
        if (method != null) {
            samlAssertionValidator.setRequiredSubjectConfirmationMethod(method.getMethodStringForSAML(samlConfig.getSamlVersion()));
        }
        this.wssConfig.setProcessor(WSConstants.SAML_TOKEN, SAMLTokenProcessor.class);
        this.wssConfig.setValidator(WSConstants.SAML_TOKEN, (Validator)samlAssertionValidator);
        this.wssConfig.setProcessor(WSConstants.SAML2_TOKEN, SAMLTokenProcessor.class);
        this.wssConfig.setValidator(WSConstants.SAML2_TOKEN, (Validator)samlAssertionValidator);
    }

    public void handle(VerifyUsernameTokenConfig usernameTokenConfig) {
        this.requestData.setAddUsernameTokenNonce(usernameTokenConfig.isCheckNonce());
        this.requestData.setAddUsernameTokenCreated(true);
        this.requestData.setUtTTL(usernameTokenConfig.getTimeToLive().intValue());
        this.wssConfig.setProcessor(WSConstants.USERNAME_TOKEN, UsernameTokenProcessor.class);
        AuthenticateUserConfig authenticateUserConfig = usernameTokenConfig.getAuthenticateUserConfig();
        if (authenticateUserConfig instanceof LDAPConfig) {
            this.wssConfig.setValidator(WSConstants.USERNAME_TOKEN, this.createLDAPValidator((LDAPConfig)authenticateUserConfig));
        } else if (authenticateUserConfig instanceof CredentialsConfig) {
            CredentialsCallbackHandler cch = (CredentialsCallbackHandler)this.requestData.getCallbackHandler();
            cch.setUsernameTokenCredentials((CredentialsConfig)authenticateUserConfig);
            this.wssConfig.setValidator(WSConstants.USERNAME_TOKEN, (Validator)new UsernameTokenValidator());
        }
    }

    private Validator createLDAPValidator(LDAPConfig ldapConfig) {
        HashMap<String, String> environmentProperties = new HashMap<String, String>();
        environmentProperties.put("java.naming.ldap.version", "3");
        environmentProperties.put("com.sun.jndi.ldap.connect.pool", "true");
        environmentProperties.put("com.sun.jndi.ldap.connect.pool.maxsize", "10");
        environmentProperties.put("com.sun.jndi.ldap.connect.pool.prefsize", "5");
        environmentProperties.put("com.sun.jndi.ldap.connect.pool.initsize", "3");
        environmentProperties.put("com.sun.jndi.ldap.connect.timeout", "10000");
        environmentProperties.put("com.sun.jndi.ldap.connect.pool.timeout", "60000");
        environmentProperties.put("com.sun.jndi.ldap.connect.pool.protocol", "plain");
        DefaultSpringSecurityContextSource defaultSpringSecurityContextSource = new DefaultSpringSecurityContextSource(ldapConfig.getProviderUrl());
        defaultSpringSecurityContextSource.setUserDn(ldapConfig.getUserDn());
        defaultSpringSecurityContextSource.setPassword(ldapConfig.getPassword());
        defaultSpringSecurityContextSource.setBaseEnvironmentProperties(environmentProperties);
        defaultSpringSecurityContextSource.afterPropertiesSet();
        FilterBasedLdapUserSearch filterBasedLdapUserSearch = new FilterBasedLdapUserSearch(ldapConfig.getSearchBase(), ldapConfig.getSearchFilter(), (BaseLdapPathContextSource)defaultSpringSecurityContextSource);
        filterBasedLdapUserSearch.setSearchSubtree(ldapConfig.isSearchInSubtree());
        BindAuthenticator bindAuthenticator = new BindAuthenticator((BaseLdapPathContextSource)defaultSpringSecurityContextSource);
        bindAuthenticator.setUserSearch((LdapUserSearch)filterBasedLdapUserSearch);
        return new LDAPValidator(new LdapAuthenticationProvider((LdapAuthenticator)bindAuthenticator));
    }
}

