/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.internal.security;

import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.core.api.security.SecurityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DelegateSecurityProvider
implements SecurityProvider {
    private SecurityProvider delegate;
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegateSecurityProvider.class);

    public DelegateSecurityProvider(SecurityProvider delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authentication authenticate(Authentication authentication) throws SecurityException {
        ClassLoader c = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Authentication authentication2 = this.delegate.authenticate(authentication);
            return authentication2;
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(c);
        }
        return null;
    }

    public boolean supports(Class<?> aClass) {
        return this.delegate.supports(aClass);
    }

    public SecurityContext createSecurityContext(Authentication authentication) throws UnknownAuthenticationTypeException {
        return this.delegate.createSecurityContext(authentication);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public void setName(String s) {
        this.delegate.setName(s);
    }
}

