/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.internal.processor;

import com.mulesoft.modules.oauth2.provider.api.client.Client;
import com.mulesoft.modules.oauth2.provider.internal.config.OAuthConfiguration;
import com.mulesoft.modules.oauth2.provider.internal.processor.OAuth2ProviderRequestProcessor;
import com.mulesoft.modules.oauth2.provider.internal.processor.RequestData;
import com.mulesoft.modules.oauth2.provider.internal.processor.RequestProcessingException;
import com.mulesoft.modules.oauth2.provider.internal.processor.RequestProcessingExceptionFactory;
import java.util.Set;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.util.Pair;

public class ValidateAuthorizationRequestProcessor
extends OAuth2ProviderRequestProcessor {
    public ValidateAuthorizationRequestProcessor(OAuthConfiguration configuration) {
        super(configuration);
    }

    public Pair<Set<String>, Client> process(RequestData requestData) throws SecurityException {
        this.failIfParameterPresentMultipleTimes(requestData, "response_type", "client_id", "redirect_uri", "scope");
        this.getSupportedResponseTypeOrFail(requestData);
        try {
            this.getMandatoryParameterOrFail(requestData, "client_id");
        }
        catch (RequestProcessingException e) {
            throw RequestProcessingExceptionFactory.noClientIdException();
        }
        Client client = this.getKnownClientOrFail(requestData);
        this.getValidRedirectionUriOrFail(client, requestData);
        Set<String> effectiveScopes = this.getEffectiveScopes(requestData, client);
        return new Pair(effectiveScopes, (Object)client);
    }
}

