/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.internal.config;

import com.mulesoft.modules.oauth2.provider.api.Constants;
import com.mulesoft.modules.oauth2.provider.api.code.AuthorizationConfig;
import com.mulesoft.modules.oauth2.provider.api.ratelimit.RateLimiter;
import com.mulesoft.modules.oauth2.provider.api.token.TokenConfig;
import com.mulesoft.modules.oauth2.provider.internal.client.ClientManager;
import com.mulesoft.modules.oauth2.provider.internal.code.AuthorizationCodeManager;
import com.mulesoft.modules.oauth2.provider.internal.security.ResourceOwnerSecurityProvider;
import com.mulesoft.modules.oauth2.provider.internal.token.TokenManager;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.security.SecurityProvider;
import org.mule.runtime.http.api.server.HttpServer;

public class OAuthConfiguration {
    private final String providerName;
    private final String host;
    private final int port;
    private final ResourceOwnerSecurityProvider resourceOwnerSecurityProvider;
    private final SecurityProvider clientSecurityProvider;
    private final TokenConfig tokenConfig;
    private final AuthorizationConfig authorizationConfig;
    private final ClientManager clientManager;
    private final TokenManager tokenManager;
    private final AuthorizationCodeManager authorizationCodeManager;
    private final Set<String> supportedScopes;
    private final Set<String> defaultScopes;
    private final Set<Constants.ProviderGrantType> supportedGrantTypes;
    private final RateLimiter rateLimiter;
    private final HttpServer httpServer;

    public OAuthConfiguration(String providerName, HttpServer httpServer, ResourceOwnerSecurityProvider resourceOwnerSecurityProvider, SecurityProvider clientSecurityProvider, TokenConfig tokenConfig, AuthorizationConfig authorizationConfig, ClientManager clientManager, AuthorizationCodeManager authorizationCodeManager, TokenManager tokenManager, Set<String> scopes, Set<String> defaultScopes, Set<Constants.ProviderGrantType> supportedGrantTypes, RateLimiter rateLimiter) {
        this.providerName = providerName;
        this.httpServer = httpServer;
        this.host = httpServer.getServerAddress().getIp();
        this.port = httpServer.getServerAddress().getPort();
        this.resourceOwnerSecurityProvider = resourceOwnerSecurityProvider;
        this.clientSecurityProvider = clientSecurityProvider;
        this.tokenConfig = tokenConfig;
        this.authorizationConfig = authorizationConfig;
        this.clientManager = clientManager;
        this.tokenManager = tokenManager;
        this.authorizationCodeManager = authorizationCodeManager;
        this.supportedScopes = scopes;
        this.defaultScopes = defaultScopes;
        this.supportedGrantTypes = supportedGrantTypes;
        this.rateLimiter = rateLimiter;
    }

    public boolean isRequestGrantTypeSupported(Constants.RequestGrantType requestGrantType) {
        Preconditions.checkArgument((requestGrantType != null ? 1 : 0) != 0, (String)"requestGrantType can't be null");
        if (CollectionUtils.isEmpty(this.supportedGrantTypes)) {
            return false;
        }
        for (Constants.ProviderGrantType providerGrantType : this.supportedGrantTypes) {
            if (!providerGrantType.getRequestGrantTypes().contains((Object)requestGrantType)) continue;
            return true;
        }
        return false;
    }

    public boolean isAuthorizationResponseTypeSupported(Constants.ResponseType authorizationResponseType) {
        Preconditions.checkArgument((authorizationResponseType != null ? 1 : 0) != 0, (String)"authorizationResponseType can't be null");
        if (CollectionUtils.isEmpty(this.supportedGrantTypes)) {
            return false;
        }
        for (Constants.ProviderGrantType providerGrantType : this.supportedGrantTypes) {
            if (providerGrantType.getAuthorizationResponseType() != authorizationResponseType) continue;
            return true;
        }
        return false;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public ResourceOwnerSecurityProvider getResourceOwnerSecurityProvider() {
        return this.resourceOwnerSecurityProvider;
    }

    public SecurityProvider getClientSecurityProvider() {
        return this.clientSecurityProvider;
    }

    public TokenConfig getTokenConfig() {
        return this.tokenConfig;
    }

    public AuthorizationConfig getAuthorizationConfig() {
        return this.authorizationConfig;
    }

    public ClientManager getClientManager() {
        return this.clientManager;
    }

    public TokenManager getTokenManager() {
        return this.tokenManager;
    }

    public AuthorizationCodeManager getAuthorizationCodeManager() {
        return this.authorizationCodeManager;
    }

    public Set<String> getSupportedScopes() {
        return this.supportedScopes;
    }

    public Set<String> getDefaultScopes() {
        return this.defaultScopes;
    }

    public Set<Constants.ProviderGrantType> getSupportedGrantTypes() {
        return this.supportedGrantTypes;
    }

    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }
}

