/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.internal.token;

import com.mulesoft.modules.oauth2.provider.api.token.AccessTokenStoreHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.util.Preconditions;

public class TokenAuthentication
implements Authentication {
    private String token;
    private Map<String, Object> properties;
    private Set<String> scopes;
    private Set<String> resourceOwnerRoles;
    private AccessTokenStoreHolder tokenHolder;

    private TokenAuthentication(Builder builder) {
        this.token = builder.token;
        this.tokenHolder = builder.tokenHolder;
        this.scopes = builder.scopes;
        this.resourceOwnerRoles = builder.resourceOwnerRoles;
        this.properties = builder.properties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TokenAuthentication tokenAuthentication) {
        return new Builder().withScopes(tokenAuthentication.getScopes()).withResourceOwnerRoles(tokenAuthentication.getResourceOwnerRoles()).withProperties(tokenAuthentication.getProperties()).withToken(tokenAuthentication.getToken()).withTokenHolder(tokenAuthentication.getTokenHolder());
    }

    public Object getCredentials() {
        return null;
    }

    public Object getPrincipal() {
        return null;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Authentication setProperties(Map<String, Object> properties) {
        return new Builder().withToken(this.token).withTokenHolder(this.tokenHolder).withScopes(this.scopes).withResourceOwnerRoles(this.resourceOwnerRoles).withProperties(properties).build();
    }

    public String getToken() {
        return this.token;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public Set<String> getResourceOwnerRoles() {
        return this.resourceOwnerRoles;
    }

    public AccessTokenStoreHolder getTokenHolder() {
        return this.tokenHolder;
    }

    public static class Builder {
        private String token;
        private AccessTokenStoreHolder tokenHolder;
        private Set<String> scopes;
        private Set<String> resourceOwnerRoles;
        private Map<String, Object> properties = new HashMap<String, Object>();

        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        public Builder withProperties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public Builder withScopes(Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder withResourceOwnerRoles(Set<String> resourceOwnerRoles) {
            this.resourceOwnerRoles = resourceOwnerRoles;
            return this;
        }

        public Builder withTokenHolder(AccessTokenStoreHolder tokenHolder) {
            this.tokenHolder = tokenHolder;
            return this;
        }

        public TokenAuthentication build() {
            Preconditions.checkArgument((this.token != null ? 1 : 0) != 0, (String)"Token must not be null in TokenAuthentication");
            return new TokenAuthentication(this);
        }
    }
}

