/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.internal.processor;

import com.mulesoft.modules.oauth2.provider.api.AuthorizationRequest;
import com.mulesoft.modules.oauth2.provider.api.Constants;
import com.mulesoft.modules.oauth2.provider.api.ResourceOwnerAuthentication;
import com.mulesoft.modules.oauth2.provider.api.client.Client;
import com.mulesoft.modules.oauth2.provider.api.token.Token;
import com.mulesoft.modules.oauth2.provider.internal.Utils;
import com.mulesoft.modules.oauth2.provider.internal.config.OAuthConfiguration;
import com.mulesoft.modules.oauth2.provider.internal.processor.OAuth2ProviderRequestProcessor;
import com.mulesoft.modules.oauth2.provider.internal.processor.RequestData;
import com.mulesoft.modules.oauth2.provider.internal.processor.RequestProcessingException;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;

public class AuthorizationRequestProcessor
extends OAuth2ProviderRequestProcessor {
    public AuthorizationRequestProcessor(OAuthConfiguration configuration) {
        super(configuration);
    }

    public void processRequest(RequestData requestData, HttpResponseBuilder httpResponseBuilder) throws SecurityException {
        Constants.ResponseType responseType = this.getSupportedResponseTypeOrFail(requestData);
        Client client = this.getKnownClientOrFail(requestData);
        Pair<Boolean, ResourceOwnerAuthentication> resourceOwnerAuthenticationResult = this.validateResourceOwnerCredentials(client, requestData);
        if (!((Boolean)resourceOwnerAuthenticationResult.getLeft()).booleanValue()) {
            throw new RequestProcessingException(RequestProcessingException.ErrorType.ACCESS_DENIED);
        }
        String redirectUri = this.getValidRedirectionUriOrFail(client, requestData);
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(client.getClientId(), responseType, redirectUri, (ResourceOwnerAuthentication)resourceOwnerAuthenticationResult.getRight());
        Set<String> effectiveScopes = this.getEffectiveScopes(requestData, client);
        if (CollectionUtils.isNotEmpty(effectiveScopes)) {
            authorizationRequest.getScopes().addAll(effectiveScopes);
        }
        if (responseType == Constants.ResponseType.CODE) {
            this.processCodeRequest(authorizationRequest, requestData, httpResponseBuilder);
        } else if (responseType == Constants.ResponseType.TOKEN) {
            this.processTokenRequest((ResourceOwnerAuthentication)resourceOwnerAuthenticationResult.getRight(), authorizationRequest, requestData, httpResponseBuilder);
        } else {
            throw new RequestProcessingException(RequestProcessingException.ErrorType.UNSUPPORTED_RESPONSE_TYPE, "Unsupported response type: " + (Object)((Object)responseType));
        }
    }

    private void processCodeRequest(AuthorizationRequest authorizationRequest, RequestData requestData, HttpResponseBuilder httpResponseBuilder) throws SecurityException {
        String authorizationGrant = this.configuration.getAuthorizationCodeManager().generateAuthorizationCode(authorizationRequest);
        String actualRedirectUri = this.buildRedirectUri(authorizationRequest.getRedirectUri(), requestData, "code", authorizationGrant);
        this.setRedirectResponse(httpResponseBuilder, actualRedirectUri);
    }

    private void processTokenRequest(ResourceOwnerAuthentication resourceOwnerAuthentication, AuthorizationRequest authorizationRequest, RequestData requestData, HttpResponseBuilder httpResponseBuilder) throws RequestProcessingException {
        Token accessToken = this.configuration.getTokenManager().grantAccessToken(Constants.RequestGrantType.TOKEN, authorizationRequest, resourceOwnerAuthentication);
        String actualRedirectUri = this.buildRedirectUri(authorizationRequest.getRedirectUri(), requestData, "access_token", accessToken.getAccessToken(), "token_type", accessToken.getType(), "expires_in", Long.toString(this.configuration.getTokenConfig().getTokenTtlInSeconds()), "scope", Utils.stringifyScopes(authorizationRequest.getScopes()));
        this.setRedirectResponse(httpResponseBuilder, actualRedirectUri);
    }
}

