/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.api;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class Constants {
    public static final String HTTP_AUTHORIZATION_SCHEME_BASIC = "Basic";
    public static final String HTTP_AUTHORIZATION_SCHEME_BEARER = "Bearer";
    public static final String UTF_8 = "UTF-8";
    public static final String RESPONSE_TYPE_PARAMETER = "response_type";
    public static final String CLIENT_ID_PARAMETER = "client_id";
    public static final String CLIENT_SECRET_PARAMETER = "client_secret";
    public static final String REDIRECT_URI_PARAMETER = "redirect_uri";
    public static final String STATE_PARAMETER = "state";
    public static final String SCOPE_PARAMETER = "scope";
    public static final String CODE_PARAMETER = "code";
    public static final String ACCESS_TOKEN_PARAMETER = "access_token";
    public static final String REFRESH_TOKEN_PARAMETER = "refresh_token";
    public static final String USERNAME_PARAMETER = "username";
    public static final String PASSWORD_PARAMETER = "password";
    public static final String GRANT_TYPE_PARAMETER = "grant_type";
    public static final String ERROR_PARAMETER = "error";
    public static final String ERROR_DESCRIPTION_PARAMETER = "error_description";
    public static final String TOKEN_TYPE_PARAMETER = "token_type";
    public static final String EXPIRES_IN_PARAMETER = "expires_in";

    private Constants() {
        throw new UnsupportedOperationException("do not instantiate");
    }

    public static enum ProviderGrantType {
        AUTHORIZATION_CODE(ResponseType.CODE, RequestGrantType.AUTHORIZATION_CODE, RequestGrantType.REFRESH_TOKEN),
        IMPLICIT(ResponseType.TOKEN, new RequestGrantType[0]),
        RESOURCE_OWNER_PASSWORD_CREDENTIALS(ResponseType.TOKEN, RequestGrantType.PASSWORD, RequestGrantType.REFRESH_TOKEN),
        CLIENT_CREDENTIALS(ResponseType.TOKEN, RequestGrantType.CLIENT_CREDENTIALS);

        private final ResponseType authorizationResponseType;
        private final Set<RequestGrantType> requestGrantTypes;

        private ProviderGrantType(ResponseType authorizationResponseType, RequestGrantType ... requestGrantTypes) {
            this.authorizationResponseType = authorizationResponseType;
            this.requestGrantTypes = new HashSet<RequestGrantType>(Arrays.asList(requestGrantTypes));
        }

        public ResponseType getAuthorizationResponseType() {
            return this.authorizationResponseType;
        }

        public Set<RequestGrantType> getRequestGrantTypes() {
            return this.requestGrantTypes;
        }
    }

    public static enum RequestGrantType {
        AUTHORIZATION_CODE,
        REFRESH_TOKEN,
        TOKEN,
        PASSWORD,
        CLIENT_CREDENTIALS;


        public String toString() {
            return StringUtils.lowerCase((String)super.toString());
        }

        public static RequestGrantType valueOfIgnoreCase(String value) {
            return RequestGrantType.valueOf(StringUtils.upperCase((String)value));
        }
    }

    public static enum ResponseType {
        CODE,
        TOKEN;


        public String toString() {
            return StringUtils.lowerCase((String)super.toString());
        }

        public static ResponseType valueOfIgnoreCase(String value) {
            return ResponseType.valueOf(StringUtils.upperCase((String)value));
        }
    }
}

