/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.api;

import com.mulesoft.modules.oauth2.provider.api.Constants;
import com.mulesoft.modules.oauth2.provider.api.ResourceOwnerAuthentication;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.StringUtils;

public class AuthorizationRequest
implements Serializable {
    private static final long serialVersionUID = -7345744993248786436L;
    private final String clientId;
    private final Constants.ResponseType responseType;
    private final ResourceOwnerAuthentication resourceOwnerAuthentication;
    private final Set<String> scopes;
    private String redirectUri;

    public AuthorizationRequest(String clientId, Constants.ResponseType responseType, String redirectUri, ResourceOwnerAuthentication resourceOwnerAuthentication) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)clientId) ? 1 : 0) != 0, (String)"clientId can't be empty");
        Preconditions.checkArgument((responseType != null ? 1 : 0) != 0, (String)"responseType can't be null");
        Preconditions.checkArgument((!StringUtils.isEmpty((String)redirectUri) ? 1 : 0) != 0, (String)"redirectUri can't be empty");
        Preconditions.checkArgument((resourceOwnerAuthentication != null ? 1 : 0) != 0, (String)"resourceOwnerAuthentication can't be null");
        this.clientId = clientId;
        this.responseType = responseType;
        this.resourceOwnerAuthentication = resourceOwnerAuthentication;
        this.redirectUri = redirectUri;
        this.scopes = new HashSet<String>();
    }

    public String getClientId() {
        return this.clientId;
    }

    public Constants.ResponseType getResponseType() {
        return this.responseType;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public ResourceOwnerAuthentication getResourceOwnerAuthentication() {
        return this.resourceOwnerAuthentication;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }
}

