/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.pqc.crypto.sphincs;

import java.security.SecureRandom;
import org.bouncycastle.shaded.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.shaded.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.shaded.crypto.Digest;
import org.bouncycastle.shaded.crypto.KeyGenerationParameters;
import org.bouncycastle.shaded.pqc.crypto.sphincs.HashFunctions;
import org.bouncycastle.shaded.pqc.crypto.sphincs.SPHINCS256KeyGenerationParameters;
import org.bouncycastle.shaded.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import org.bouncycastle.shaded.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import org.bouncycastle.shaded.pqc.crypto.sphincs.Tree;

public class SPHINCS256KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;
    private Digest treeDigest;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        this.treeDigest = ((SPHINCS256KeyGenerationParameters)keyGenerationParameters).getTreeDigest();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        Tree.leafaddr leafaddr2 = new Tree.leafaddr();
        byte[] byArray = new byte[1088];
        this.random.nextBytes(byArray);
        byte[] byArray2 = new byte[1056];
        System.arraycopy(byArray, 32, byArray2, 0, 1024);
        leafaddr2.level = 11;
        leafaddr2.subtree = 0L;
        leafaddr2.subleaf = 0L;
        HashFunctions hashFunctions = new HashFunctions(this.treeDigest);
        Tree.treehash(hashFunctions, byArray2, 1024, 5, byArray, leafaddr2, byArray2, 0);
        return new AsymmetricCipherKeyPair(new SPHINCSPublicKeyParameters(byArray2, this.treeDigest.getAlgorithmName()), new SPHINCSPrivateKeyParameters(byArray, this.treeDigest.getAlgorithmName()));
    }
}

