/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.openpgp.operator.jcajce;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;
import org.bouncycastle.shaded.openpgp.PGPAlgorithmParameters;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.PGPKeyPair;
import org.bouncycastle.shaded.openpgp.PGPPrivateKey;
import org.bouncycastle.shaded.openpgp.PGPPublicKey;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcaPGPKeyConverter;

public class JcaPGPKeyPair
extends PGPKeyPair {
    private static PGPPublicKey getPublicKey(int n, PublicKey publicKey, Date date) throws PGPException {
        return new JcaPGPKeyConverter().getPGPPublicKey(n, publicKey, date);
    }

    private static PGPPublicKey getPublicKey(int n, PGPAlgorithmParameters pGPAlgorithmParameters, PublicKey publicKey, Date date) throws PGPException {
        return new JcaPGPKeyConverter().getPGPPublicKey(n, pGPAlgorithmParameters, publicKey, date);
    }

    private static PGPPrivateKey getPrivateKey(PGPPublicKey pGPPublicKey, PrivateKey privateKey) throws PGPException {
        return new JcaPGPKeyConverter().getPGPPrivateKey(pGPPublicKey, privateKey);
    }

    public JcaPGPKeyPair(int n, KeyPair keyPair, Date date) throws PGPException {
        this.pub = JcaPGPKeyPair.getPublicKey(n, keyPair.getPublic(), date);
        this.priv = JcaPGPKeyPair.getPrivateKey(this.pub, keyPair.getPrivate());
    }

    public JcaPGPKeyPair(int n, PGPAlgorithmParameters pGPAlgorithmParameters, KeyPair keyPair, Date date) throws PGPException {
        this.pub = JcaPGPKeyPair.getPublicKey(n, pGPAlgorithmParameters, keyPair.getPublic(), date);
        this.priv = JcaPGPKeyPair.getPrivateKey(this.pub, keyPair.getPrivate());
    }
}

