/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.openpgp.examples;

import java.io.FileInputStream;
import java.security.Security;
import java.util.Iterator;
import org.bouncycastle.shaded.jce.provider.BouncyCastleProvider;
import org.bouncycastle.shaded.openpgp.PGPPublicKey;
import org.bouncycastle.shaded.openpgp.PGPPublicKeyRing;
import org.bouncycastle.shaded.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.shaded.openpgp.PGPUtil;
import org.bouncycastle.shaded.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.shaded.util.encoders.Hex;

public class PubringDump {
    public static String getAlgorithm(int n) {
        switch (n) {
            case 1: {
                return "RSA_GENERAL";
            }
            case 2: {
                return "RSA_ENCRYPT";
            }
            case 3: {
                return "RSA_SIGN";
            }
            case 16: {
                return "ELGAMAL_ENCRYPT";
            }
            case 17: {
                return "DSA";
            }
            case 18: {
                return "ECDH";
            }
            case 19: {
                return "ECDSA";
            }
            case 20: {
                return "ELGAMAL_GENERAL";
            }
            case 21: {
                return "DIFFIE_HELLMAN";
            }
        }
        return "unknown";
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        PGPPublicKeyRingCollection pGPPublicKeyRingCollection = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream(new FileInputStream(stringArray[0])), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Iterator<PGPPublicKeyRing> iterator = pGPPublicKeyRingCollection.getKeyRings();
        while (iterator.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = iterator.next();
            try {
                pGPPublicKeyRing.getPublicKey();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            Iterator<PGPPublicKey> iterator2 = pGPPublicKeyRing.getPublicKeys();
            boolean bl = true;
            while (iterator2.hasNext()) {
                PGPPublicKey pGPPublicKey = iterator2.next();
                if (bl) {
                    System.out.println("Key ID: " + Long.toHexString(pGPPublicKey.getKeyID()));
                    bl = false;
                } else {
                    System.out.println("Key ID: " + Long.toHexString(pGPPublicKey.getKeyID()) + " (subkey)");
                }
                System.out.println("            Algorithm: " + PubringDump.getAlgorithm(pGPPublicKey.getAlgorithm()));
                System.out.println("            Fingerprint: " + new String(Hex.encode(pGPPublicKey.getFingerprint())));
            }
        }
    }
}

