/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.openpgp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.shaded.util.encoders.Hex;

public class PGPSessionKey {
    private final int algorithm;
    private final byte[] sessionKey;

    public PGPSessionKey(int n, byte[] byArray) {
        this.algorithm = n;
        this.sessionKey = byArray;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getKey() {
        byte[] byArray = new byte[this.sessionKey.length];
        System.arraycopy(this.sessionKey, 0, byArray, 0, this.sessionKey.length);
        return byArray;
    }

    public String toString() {
        return this.algorithm + ":" + this.sessionKey;
    }

    public static PGPSessionKey fromAsciiRepresentation(String string) {
        Pattern pattern = Pattern.compile("(\\d{1,3}):([0-9A-Fa-f]+)");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Provided ascii encoding does not match expected format <algo-num>:<hex-key>");
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        return new PGPSessionKey(Integer.parseInt(string2), Hex.decode(string3));
    }
}

