/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.jcajce.provider.asymmetric.dsa;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.util.Hashtable;
import org.bouncycastle.shaded.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.shaded.crypto.CryptoServicesRegistrar;
import org.bouncycastle.shaded.crypto.digests.SHA256Digest;
import org.bouncycastle.shaded.crypto.generators.DSAKeyPairGenerator;
import org.bouncycastle.shaded.crypto.generators.DSAParametersGenerator;
import org.bouncycastle.shaded.crypto.params.DSAKeyGenerationParameters;
import org.bouncycastle.shaded.crypto.params.DSAParameterGenerationParameters;
import org.bouncycastle.shaded.crypto.params.DSAParameters;
import org.bouncycastle.shaded.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.shaded.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.shaded.jcajce.provider.asymmetric.dsa.BCDSAPrivateKey;
import org.bouncycastle.shaded.jcajce.provider.asymmetric.dsa.BCDSAPublicKey;
import org.bouncycastle.shaded.jcajce.provider.asymmetric.util.PrimeCertaintyCalculator;
import org.bouncycastle.shaded.jce.provider.BouncyCastleProvider;
import org.bouncycastle.shaded.util.Integers;
import org.bouncycastle.shaded.util.Properties;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Hashtable params = new Hashtable();
    private static Object lock = new Object();
    DSAKeyGenerationParameters param;
    DSAKeyPairGenerator engine = new DSAKeyPairGenerator();
    int strength = 2048;
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("DSA");
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        if (n < 512 || n > 4096 || n < 1024 && n % 64 != 0 || n >= 1024 && n % 1024 != 0) {
            throw new InvalidParameterException("strength must be from 512 - 4096 and a multiple of 1024 above 1024");
        }
        DSAParameterSpec dSAParameterSpec = BouncyCastleProvider.CONFIGURATION.getDSADefaultParameters(n);
        if (dSAParameterSpec != null) {
            this.param = new DSAKeyGenerationParameters(secureRandom, new DSAParameters(dSAParameterSpec.getP(), dSAParameterSpec.getQ(), dSAParameterSpec.getG()));
            this.engine.init(this.param);
            this.initialised = true;
        } else {
            this.strength = n;
            this.random = secureRandom;
            this.initialised = false;
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a DSAParameterSpec");
        }
        DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
        this.param = new DSAKeyGenerationParameters(secureRandom, new DSAParameters(dSAParameterSpec.getP(), dSAParameterSpec.getQ(), dSAParameterSpec.getG()));
        this.engine.init(this.param);
        this.initialised = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyPair generateKeyPair() {
        Object object;
        Object object2;
        Object object3;
        if (!this.initialised) {
            object3 = Integers.valueOf(this.strength);
            if (params.containsKey(object3)) {
                this.param = (DSAKeyGenerationParameters)params.get(object3);
            } else {
                object2 = lock;
                synchronized (object2) {
                    if (params.containsKey(object3)) {
                        this.param = (DSAKeyGenerationParameters)params.get(object3);
                    } else {
                        int n = PrimeCertaintyCalculator.getDefaultCertainty(this.strength);
                        if (this.strength == 1024) {
                            object = new DSAParametersGenerator();
                            if (Properties.isOverrideSet("org.bouncycastle.shaded.dsa.FIPS186-2for1024bits")) {
                                ((DSAParametersGenerator)object).init(this.strength, n, this.random);
                            } else {
                                DSAParameterGenerationParameters dSAParameterGenerationParameters = new DSAParameterGenerationParameters(1024, 160, n, this.random);
                                ((DSAParametersGenerator)object).init(dSAParameterGenerationParameters);
                            }
                        } else if (this.strength > 1024) {
                            DSAParameterGenerationParameters dSAParameterGenerationParameters = new DSAParameterGenerationParameters(this.strength, 256, n, this.random);
                            object = new DSAParametersGenerator(SHA256Digest.newInstance());
                            ((DSAParametersGenerator)object).init(dSAParameterGenerationParameters);
                        } else {
                            object = new DSAParametersGenerator();
                            ((DSAParametersGenerator)object).init(this.strength, n, this.random);
                        }
                        this.param = new DSAKeyGenerationParameters(this.random, ((DSAParametersGenerator)object).generateParameters());
                        params.put(object3, this.param);
                    }
                }
            }
            this.engine.init(this.param);
            this.initialised = true;
        }
        object3 = this.engine.generateKeyPair();
        object2 = (DSAPublicKeyParameters)((AsymmetricCipherKeyPair)object3).getPublic();
        object = (DSAPrivateKeyParameters)((AsymmetricCipherKeyPair)object3).getPrivate();
        return new KeyPair(new BCDSAPublicKey((DSAPublicKeyParameters)object2), new BCDSAPrivateKey((DSAPrivateKeyParameters)object));
    }
}

