/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.gpg.keybox;

import java.io.IOException;
import org.bouncycastle.shaded.gpg.keybox.Blob;
import org.bouncycastle.shaded.gpg.keybox.BlobType;
import org.bouncycastle.shaded.gpg.keybox.KeyBoxByteBuffer;
import org.bouncycastle.shaded.util.Arrays;
import org.bouncycastle.shaded.util.encoders.Hex;

public class FirstBlob
extends Blob {
    private final int headerFlags;
    private final long fileCreatedAt;
    private final long lastMaintenanceRun;

    private FirstBlob(int n, long l, BlobType blobType, int n2, int n3, long l2, long l3) {
        super(n, l, blobType, n2);
        this.headerFlags = n3;
        this.fileCreatedAt = l2;
        this.lastMaintenanceRun = l3;
    }

    static FirstBlob parseContent(int n, long l, BlobType blobType, int n2, KeyBoxByteBuffer keyBoxByteBuffer) throws IOException {
        int n3 = keyBoxByteBuffer.u16();
        byte[] byArray = keyBoxByteBuffer.bN(4);
        if (!Arrays.areEqual(byArray, magicBytes)) {
            throw new IOException("Incorrect magic expecting " + Hex.toHexString(magicBytes) + " but got " + Hex.toHexString(byArray));
        }
        keyBoxByteBuffer.u32();
        long l2 = keyBoxByteBuffer.u32();
        long l3 = keyBoxByteBuffer.u32();
        keyBoxByteBuffer.u32();
        keyBoxByteBuffer.u32();
        return new FirstBlob(n, l, blobType, n2, n3, l2, l3);
    }

    public int getHeaderFlags() {
        return this.headerFlags;
    }

    public long getFileCreatedAt() {
        return this.fileCreatedAt;
    }

    public long getLastMaintenanceRun() {
        return this.lastMaintenanceRun;
    }
}

