/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.crypto.hpke;

import org.bouncycastle.shaded.crypto.Digest;
import org.bouncycastle.shaded.crypto.digests.SHA256Digest;
import org.bouncycastle.shaded.crypto.digests.SHA384Digest;
import org.bouncycastle.shaded.crypto.digests.SHA512Digest;
import org.bouncycastle.shaded.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.shaded.crypto.params.HKDFParameters;
import org.bouncycastle.shaded.util.Arrays;
import org.bouncycastle.shaded.util.Memoable;
import org.bouncycastle.shaded.util.Pack;

class HKDF {
    private static final String versionLabel = "HPKE-v1";
    private final HKDFBytesGenerator kdf;
    private final int hashLength;

    HKDF(short s) {
        Memoable memoable;
        switch (s) {
            case 1: {
                memoable = new SHA256Digest();
                break;
            }
            case 2: {
                memoable = new SHA384Digest();
                break;
            }
            case 3: {
                memoable = new SHA512Digest();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid kdf id");
            }
        }
        this.kdf = new HKDFBytesGenerator((Digest)((Object)memoable));
        this.hashLength = memoable.getDigestSize();
    }

    int getHashSize() {
        return this.hashLength;
    }

    protected byte[] LabeledExtract(byte[] byArray, byte[] byArray2, String string, byte[] byArray3) {
        if (byArray == null) {
            byArray = new byte[this.hashLength];
        }
        byte[] byArray4 = Arrays.concatenate(versionLabel.getBytes(), byArray2, string.getBytes(), byArray3);
        return this.kdf.extractPRK(byArray, byArray4);
    }

    protected byte[] LabeledExpand(byte[] byArray, byte[] byArray2, String string, byte[] byArray3, int n) {
        if (n > 65536) {
            throw new IllegalArgumentException("Expand length cannot be larger than 2^16");
        }
        byte[] byArray4 = Arrays.concatenate(Pack.shortToBigEndian((short)n), versionLabel.getBytes(), byArray2, string.getBytes());
        this.kdf.init(HKDFParameters.skipExtractParameters(byArray, Arrays.concatenate(byArray4, byArray3)));
        byte[] byArray5 = new byte[n];
        this.kdf.generateBytes(byArray5, 0, byArray5.length);
        return byArray5;
    }
}

