/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.crypto.agreement;

import org.bouncycastle.shaded.crypto.CipherParameters;
import org.bouncycastle.shaded.crypto.CryptoServicesRegistrar;
import org.bouncycastle.shaded.crypto.RawAgreement;
import org.bouncycastle.shaded.crypto.agreement.Utils;
import org.bouncycastle.shaded.crypto.params.X448PrivateKeyParameters;
import org.bouncycastle.shaded.crypto.params.X448PublicKeyParameters;

public final class X448Agreement
implements RawAgreement {
    private X448PrivateKeyParameters privateKey;

    @Override
    public void init(CipherParameters cipherParameters) {
        this.privateKey = (X448PrivateKeyParameters)cipherParameters;
        CryptoServicesRegistrar.checkConstraints(Utils.getDefaultProperties("X448", this.privateKey));
    }

    @Override
    public int getAgreementSize() {
        return 56;
    }

    @Override
    public void calculateAgreement(CipherParameters cipherParameters, byte[] byArray, int n) {
        this.privateKey.generateSecret((X448PublicKeyParameters)cipherParameters, byArray, n);
    }
}

