/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.crypto.agreement;

import java.math.BigInteger;
import org.bouncycastle.shaded.crypto.BasicAgreement;
import org.bouncycastle.shaded.crypto.CipherParameters;
import org.bouncycastle.shaded.crypto.CryptoServicesRegistrar;
import org.bouncycastle.shaded.crypto.agreement.Utils;
import org.bouncycastle.shaded.crypto.params.ECDomainParameters;
import org.bouncycastle.shaded.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.shaded.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.shaded.math.ec.ECAlgorithms;
import org.bouncycastle.shaded.math.ec.ECConstants;
import org.bouncycastle.shaded.math.ec.ECPoint;

public class ECDHBasicAgreement
implements BasicAgreement {
    private ECPrivateKeyParameters key;

    @Override
    public void init(CipherParameters cipherParameters) {
        this.key = (ECPrivateKeyParameters)cipherParameters;
        CryptoServicesRegistrar.checkConstraints(Utils.getDefaultProperties("ECDH", this.key));
    }

    @Override
    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        ECPoint eCPoint;
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)cipherParameters;
        ECDomainParameters eCDomainParameters = this.key.getParameters();
        if (!eCDomainParameters.equals(eCPublicKeyParameters.getParameters())) {
            throw new IllegalStateException("ECDH public key has wrong domain parameters");
        }
        BigInteger bigInteger = this.key.getD();
        ECPoint eCPoint2 = ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), eCPublicKeyParameters.getQ());
        if (eCPoint2.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid public key for ECDH");
        }
        BigInteger bigInteger2 = eCDomainParameters.getH();
        if (!bigInteger2.equals(ECConstants.ONE)) {
            bigInteger = eCDomainParameters.getHInv().multiply(bigInteger).mod(eCDomainParameters.getN());
            eCPoint2 = ECAlgorithms.referenceMultiply(eCPoint2, bigInteger2);
        }
        if ((eCPoint = eCPoint2.multiply(bigInteger).normalize()).isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECDH");
        }
        return eCPoint.getAffineXCoord().toBigInteger();
    }
}

