/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.xml.reference;

import com.mulesoft.modules.cryptography.api.xml.config.XmlSignDigestAlgorithm;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.xml.impl.XmlKeyImpl;
import com.mulesoft.modules.cryptography.internal.xml.reference.SignatureContextProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLObject;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EnvelopingSignatureContextProvider
implements SignatureContextProvider {
    private static final boolean IS_JAVA_8 = "1.8".equals(System.getProperty("java.specification.version"));
    private final XmlSignDigestAlgorithm digestAlgorithm;
    private final Document document;

    public EnvelopingSignatureContextProvider(XmlSignDigestAlgorithm digestAlgorithm, Document document) {
        this.digestAlgorithm = digestAlgorithm;
        this.document = document;
    }

    @Override
    public Document preProcess(Document document) {
        if (!IS_JAVA_8) {
            document.setStrictErrorChecking(false);
        }
        return document;
    }

    @Override
    public Document postProcess(Document document) {
        if (!IS_JAVA_8) {
            LinkedList<Node> invalidChildren = new LinkedList<Node>();
            for (int i = 0; i < document.getChildNodes().getLength(); ++i) {
                Node child = document.getChildNodes().item(i);
                if ("dsig".equals(child.getPrefix())) continue;
                invalidChildren.add(child);
            }
            invalidChildren.forEach(document::removeChild);
        }
        return document;
    }

    @Override
    public Reference getReference() {
        try {
            DigestMethod digestMethod = XmlKeyImpl.fac.newDigestMethod(this.digestAlgorithm.getAlgorithm(), null);
            return XmlKeyImpl.fac.newReference("#data", digestMethod);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Error getting reference of element to sign"), (ErrorTypeDefinition)CryptoErrors.PARAMETERS, (Throwable)e);
        }
    }

    @Override
    public List<XMLObject> getReferencedObjects() {
        ArrayList<XMLObject> objects = new ArrayList<XMLObject>();
        DOMStructure structure = new DOMStructure(this.document.getDocumentElement());
        objects.add(XmlKeyImpl.fac.newXMLObject(Collections.singletonList(structure), "data", null, "UTF-8"));
        return objects;
    }

    @Override
    public Node getSignatureParentNode() {
        return this.document;
    }
}

