/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.pgp;

import com.mulesoft.modules.cryptography.api.pgp.config.PgpEncryptionAlgorithm;
import com.mulesoft.modules.cryptography.api.pgp.config.PgpKeyInfo;
import com.mulesoft.modules.cryptography.internal.FipsUtils;
import com.mulesoft.modules.cryptography.internal.WrappedErrorPipedInputStream;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.pgp.config.PgpConfiguration;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.bouncycastle.shaded.bcpg.ArmoredOutputStream;
import org.bouncycastle.shaded.openpgp.PGPCompressedData;
import org.bouncycastle.shaded.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.shaded.openpgp.PGPEncryptedData;
import org.bouncycastle.shaded.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.shaded.openpgp.PGPEncryptedDataList;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.PGPLiteralData;
import org.bouncycastle.shaded.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.shaded.openpgp.PGPOnePassSignature;
import org.bouncycastle.shaded.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.shaded.openpgp.PGPPrivateKey;
import org.bouncycastle.shaded.openpgp.PGPPublicKey;
import org.bouncycastle.shaded.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.shaded.openpgp.PGPSignature;
import org.bouncycastle.shaded.openpgp.PGPSignatureGenerator;
import org.bouncycastle.shaded.openpgp.PGPSignatureList;
import org.bouncycastle.shaded.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.shaded.openpgp.PGPUtil;
import org.bouncycastle.shaded.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.shaded.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.shaded.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.shaded.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.shaded.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.bouncycastle.shaded.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.shaded.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.sdk.api.streaming.bytes.ImmutableFileRepeatableInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpEncrypter {
    public static final BcKeyFingerprintCalculator KEY_FINGERPRINT_CALCULATOR = new BcKeyFingerprintCalculator();
    public static final BcPGPDigestCalculatorProvider PGP_DIGEST_CALCULATOR_PROVIDER = new BcPGPDigestCalculatorProvider();
    public static final BcPBESecretKeyDecryptorBuilder PBE_SECRET_KEY_DECRYPTOR_BUILDER = new BcPBESecretKeyDecryptorBuilder(PGP_DIGEST_CALCULATOR_PROVIDER);
    private static final int BUFFER_SIZE = 65536;
    private static final String PGP_ERROR_MESSAGE = "Could not encrypt with PGP";
    private final Logger LOGGER = LoggerFactory.getLogger(PgpEncrypter.class);
    private PgpConfiguration config;

    public static String formatKeyFingerprint(Long fingerprint) {
        return Long.toHexString(fingerprint).toUpperCase();
    }

    public PgpEncrypter(PgpConfiguration config) {
        this.config = config;
    }

    public InputStream encrypt(InputStream inputData, String fileName, PgpKeyInfo encryptKeyInfo, PgpEncryptionAlgorithm algorithm, boolean disableMDC, Scheduler scheduler, Boolean armoredTransform) {
        return this.encrypt(inputData, fileName, encryptKeyInfo, algorithm, Optional.empty(), disableMDC, scheduler, armoredTransform);
    }

    public InputStream encrypt(InputStream inputData, String fileName, PgpKeyInfo encryptKeyInfo, PgpEncryptionAlgorithm algorithm, Optional<PgpKeyInfo> signKeyInfo, boolean disableMDC, Scheduler scheduler, Boolean armoredTransform) {
        try {
            if (encryptKeyInfo.isSymmetric()) {
                throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Symmetric encryption with PGP is not implemented yet"), (ErrorTypeDefinition)CryptoErrors.ENCRYPTION);
            }
            PGPPublicKey encryptionKey = encryptKeyInfo.getPublicKey(this.config.getKeystore());
            JcePGPDataEncryptorBuilder encryptorBuilder = new JcePGPDataEncryptorBuilder(algorithm.getNumericId());
            encryptorBuilder.setWithIntegrityPacket(!disableMDC);
            PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator(encryptorBuilder, false);
            BcPublicKeyKeyEncryptionMethodGenerator methodGenerator = new BcPublicKeyKeyEncryptionMethodGenerator(encryptionKey);
            encryptedDataGenerator.addMethod(methodGenerator);
            PGPCompressedDataGenerator compressedDataGenerator = new PGPCompressedDataGenerator(1);
            PGPLiteralDataGenerator literalDataGenerator = new PGPLiteralDataGenerator();
            WrappedErrorPipedInputStream input = new WrappedErrorPipedInputStream();
            PipedOutputStream pipedOutputStream = new PipedOutputStream(input);
            ArmoredOutputStream out = new ArmoredOutputStream(pipedOutputStream);
            scheduler.submit(() -> this.encryptAsync(encryptedDataGenerator, compressedDataGenerator, out, input, pipedOutputStream, signKeyInfo, literalDataGenerator, fileName, inputData, armoredTransform));
            return input;
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)PGP_ERROR_MESSAGE), (ErrorTypeDefinition)CryptoErrors.ENCRYPTION, (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public InputStream encryptAsync(PGPEncryptedDataGenerator encryptedDataGenerator, PGPCompressedDataGenerator compressedDataGenerator, OutputStream out, WrappedErrorPipedInputStream input, PipedOutputStream pipedOutputStream, Optional<PgpKeyInfo> signKeyInfo, PGPLiteralDataGenerator literalDataGenerator, String fileName, InputStream inputData, boolean armoredTransform) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected SignatureGeneratorClosable generateSignatureGeneratorClosable(Optional<PgpKeyInfo> signerKeyInfo, OutputStream compressorEntryPoint) throws PGPException, IOException {
        boolean enabled = signerKeyInfo.isPresent();
        PGPSignatureGenerator signatureGenerator = null;
        if (enabled) {
            PGPPrivateKey senderPrivateKey = signerKeyInfo.get().getPrivateKey(this.config.getKeystore());
            signatureGenerator = this.prepareSignatureGenerator(compressorEntryPoint, senderPrivateKey);
        }
        if (signatureGenerator != null) {
            return new SignatureGeneratorClosable(enabled, signatureGenerator, compressorEntryPoint);
        }
        return new NullSignatureGeneratorClosable();
    }

    private PGPSignatureGenerator prepareSignatureGenerator(OutputStream compressedOutputStream, PGPPrivateKey senderPrivateKey) throws PGPException, IOException {
        BcPGPContentSignerBuilder signerBuilder = new BcPGPContentSignerBuilder(senderPrivateKey.getPublicKeyPacket().getAlgorithm(), 2);
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(signerBuilder);
        signatureGenerator.init(0, senderPrivateKey);
        PGPSignatureSubpacketGenerator signatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
        signatureSubpacketGenerator.addSignerUserID(false, this.getUserIdFrom(senderPrivateKey.getKeyID()));
        signatureGenerator.setHashedSubpackets(signatureSubpacketGenerator.generate());
        signatureGenerator.generateOnePassVersion(false).encode(compressedOutputStream);
        return signatureGenerator;
    }

    private String getUserIdFrom(long keyId) {
        String retrievedFromFingerprintMapping = this.config.getKeystore().getPrincipalFromFingerprint(keyId);
        if (retrievedFromFingerprintMapping != null) {
            return retrievedFromFingerprintMapping;
        }
        return this.config.getKeystore().getPublicKey(keyId).getUserIDs().next();
    }

    private PGPEncryptedDataList getEncryptedDataListFromInput(InputStream inputData, Object pgpObject) throws IOException, PGPException {
        InputStream decodedInputStream = PGPUtil.getDecoderStream(inputData);
        JcaPGPObjectFactory pgpF = new JcaPGPObjectFactory(decodedInputStream);
        pgpObject = pgpF.nextObject();
        if (pgpObject == null) {
            throw new PGPException("Invalid PGP message");
        }
        PGPEncryptedDataList enc = pgpObject instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)pgpObject : (PGPEncryptedDataList)pgpF.nextObject();
        return enc;
    }

    private Map.Entry<PGPPublicKeyEncryptedData, PGPPrivateKey> getPublicAndPrivateKeyTuple(PGPEncryptedDataList encryptedDataList) {
        PGPPublicKeyEncryptedData pbe = null;
        PGPPrivateKey privateKey = null;
        Iterator<PGPEncryptedData> it = encryptedDataList.getEncryptedDataObjects();
        while (it.hasNext()) {
            pbe = (PGPPublicKeyEncryptedData)it.next();
            if (!this.config.getKeystore().hasPrivateKey(pbe.getKeyID())) continue;
            privateKey = this.config.getKeystore().decryptPrivateKey(pbe.getKeyID());
            break;
        }
        if (privateKey == null) {
            throw new ModuleException("No valid private key found", (ErrorTypeDefinition)CryptoErrors.MISSING_KEY);
        }
        return new AbstractMap.SimpleEntry<PGPPublicKeyEncryptedData, Object>(pbe, privateKey);
    }

    private InputStream decodeInputDataWithKeys(PGPPublicKeyEncryptedData pbe, PGPPrivateKey privateKey) throws PGPException {
        JcePublicKeyDataDecryptorFactoryBuilder jcePublicKeyDataDecryptorFactoryBuilder = new JcePublicKeyDataDecryptorFactoryBuilder();
        FipsUtils.getBcSecurityProviderIfApplicable().ifPresent(jcePublicKeyDataDecryptorFactoryBuilder::setProvider);
        return pbe.getDataStream(jcePublicKeyDataDecryptorFactoryBuilder.build(privateKey));
    }

    public InputStream decrypt(InputStream inputData, String fileName, boolean validateIfSignatureFound) {
        try {
            boolean shouldValidateSignature;
            DecryptedData decryptedData = this.getDecryptedInputStream(inputData, fileName);
            PGPOnePassSignature onePassSignature = decryptedData.getOnePassSignature();
            JcaPGPObjectFactory pgpObjectFactory = decryptedData.getJcaPGPObjectFactory();
            InputStream literalDataStream = decryptedData.getDecryptedInputStream();
            boolean bl = shouldValidateSignature = onePassSignature != null && validateIfSignatureFound;
            if (shouldValidateSignature) {
                return this.verifySignature(onePassSignature, pgpObjectFactory, literalDataStream);
            }
            return literalDataStream;
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not decrypt PGP data"), (ErrorTypeDefinition)CryptoErrors.DECRYPTION, (Throwable)e);
        }
    }

    private InputStream verifySignature(PGPOnePassSignature onePassSignature, JcaPGPObjectFactory pgpObjectFactory, InputStream literalDataStream) throws PGPException, IOException {
        int len;
        this.LOGGER.debug("One pass signature found, and validation was requested. Starting validation procedure");
        onePassSignature.init(new BcPGPContentVerifierBuilderProvider(), this.config.getKeystore().getPublicKey(onePassSignature.getKeyID()));
        byte[] buffer = new byte[1024];
        this.LOGGER.debug("About to do a pass over the literal decrypted data");
        TemporarySaverDataUtil temporarySaverDataUtil = new TemporarySaverDataUtil();
        while ((len = literalDataStream.read(buffer)) > -1) {
            temporarySaverDataUtil.write(buffer, 0, len);
            onePassSignature.update(buffer, 0, len);
        }
        PGPSignatureList signatureList = (PGPSignatureList)pgpObjectFactory.nextObject();
        PGPSignature signature = signatureList.get(0);
        PGPPublicKey publicKey = this.config.getKeystore().getPublicKey(signature.getKeyID());
        JcaPGPContentVerifierBuilderProvider verifierBuilderProvider = new JcaPGPContentVerifierBuilderProvider();
        FipsUtils.getBcSecurityProviderIfApplicable().ifPresent(verifierBuilderProvider::setProvider);
        signature.init(verifierBuilderProvider, publicKey);
        if (!onePassSignature.verify(signature)) {
            this.LOGGER.error("Discovered signature verification failed!");
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not verify signature of decrypted message"), (ErrorTypeDefinition)CryptoErrors.DECRYPTION);
        }
        return temporarySaverDataUtil.getDecryptedData();
    }

    private DecryptedData getDecryptedInputStream(InputStream inputData, String fileName) throws PGPException, IOException {
        DecryptedData decryptedData = new DecryptedData();
        Object pgpObject = null;
        PGPEncryptedDataList encryptedDataList = this.getEncryptedDataListFromInput(inputData, pgpObject);
        Map.Entry<PGPPublicKeyEncryptedData, PGPPrivateKey> publicAndPrivateKeyTuple = this.getPublicAndPrivateKeyTuple(encryptedDataList);
        PGPPublicKeyEncryptedData pbe = publicAndPrivateKeyTuple.getKey();
        PGPPrivateKey privateKey = publicAndPrivateKeyTuple.getValue();
        InputStream decodedInputStream = this.decodeInputDataWithKeys(pbe, privateKey);
        JcaPGPObjectFactory pgpObjectFactory = new JcaPGPObjectFactory(decodedInputStream);
        pgpObject = pgpObjectFactory.nextObject();
        decryptedData.setJcaPGPObjectFactory(pgpObjectFactory);
        PGPOnePassSignature onePassSignature = null;
        while (!(pgpObject instanceof PGPLiteralData)) {
            if (pgpObject instanceof PGPOnePassSignatureList) {
                onePassSignature = ((PGPOnePassSignatureList)pgpObject).get(0);
                decryptedData.setOnePassSignature(onePassSignature);
                pgpObject = pgpObjectFactory.nextObject();
                continue;
            }
            if (pgpObject instanceof PGPCompressedData) {
                PGPLiteralData pgpLiteralData;
                PGPCompressedData cData = (PGPCompressedData)pgpObject;
                pgpObjectFactory = new JcaPGPObjectFactory(cData.getDataStream());
                decryptedData.setJcaPGPObjectFactory(pgpObjectFactory);
                pgpObject = pgpObjectFactory.nextObject();
                if (!StringUtils.isBlank((String)fileName) && pgpObject instanceof PGPLiteralData && (pgpLiteralData = (PGPLiteralData)pgpObject).getFileName().equals(fileName)) continue;
            }
            throw new PGPException("input is not PGPLiteralData - type unknown.");
        }
        PGPLiteralData pgpLiteralData = (PGPLiteralData)pgpObject;
        InputStream literalDataStream = pgpLiteralData.getInputStream();
        decryptedData.setDecryptedInputStream(literalDataStream);
        return decryptedData;
    }

    private class DecryptedData {
        private InputStream decryptedInputStream;
        private PGPOnePassSignature onePassSignature;
        private JcaPGPObjectFactory jcaPGPObjectFactory;

        private DecryptedData() {
        }

        public void setDecryptedInputStream(InputStream decryptedInputStream) {
            this.decryptedInputStream = decryptedInputStream;
        }

        public void setOnePassSignature(PGPOnePassSignature onePassSignature) {
            this.onePassSignature = onePassSignature;
        }

        public void setJcaPGPObjectFactory(JcaPGPObjectFactory jcaPGPObjectFactory) {
            this.jcaPGPObjectFactory = jcaPGPObjectFactory;
        }

        public InputStream getDecryptedInputStream() {
            return this.decryptedInputStream;
        }

        public PGPOnePassSignature getOnePassSignature() {
            return this.onePassSignature;
        }

        public JcaPGPObjectFactory getJcaPGPObjectFactory() {
            return this.jcaPGPObjectFactory;
        }
    }

    private class TemporarySaverDataUtil {
        private static final int AMOUNT_OUT_BYTES_AROUND_220MB = 220686720;
        private int amountOfBytesLoaded = 0;
        private File temp = null;
        private OutputStream tempFileOutputStream = null;
        private ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();

        private TemporarySaverDataUtil() {
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.amountOfBytesLoaded < 220686720) {
                this.amountOfBytesLoaded += b.length;
                this.byteArrayOutputStream.write(b, off, len);
            } else {
                this.initializeTemporaryFileIfNull();
                this.tempFileOutputStream.write(b, off, len);
            }
        }

        public InputStream getDecryptedData() throws IOException {
            if (this.amountOfBytesLoaded < 220686720) {
                this.byteArrayOutputStream.flush();
                return new ByteArrayInputStream(this.byteArrayOutputStream.toByteArray());
            }
            this.byteArrayOutputStream = null;
            return new ImmutableFileRepeatableInputStream(this.temp, true);
        }

        private void initializeTemporaryFileIfNull() throws IOException {
            if (this.temp == null) {
                int len;
                this.temp = File.createTempFile("com.mulesoft.modules.cryptography", ".tmp");
                PgpEncrypter.this.LOGGER.debug("200 MB size reached while decrypting and verifying signature, to avoid OOM, writing TEMP file to: {}", (Object)this.temp.getAbsolutePath());
                this.tempFileOutputStream = new FileOutputStream(this.temp);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.byteArrayOutputStream.toByteArray());
                byte[] buffer = new byte[1024];
                while ((len = byteArrayInputStream.read(buffer)) > -1) {
                    this.tempFileOutputStream.write(buffer, 0, len);
                }
            }
        }
    }

    private class SignatureGeneratorClosable
    implements AutoCloseable {
        private final boolean enabled;
        private final PGPSignatureGenerator signatureGenerator;
        private final OutputStream compressorEntryPoint;

        private SignatureGeneratorClosable(boolean enabled, PGPSignatureGenerator signatureGenerator, OutputStream compressorEntryPoint) {
            this.enabled = enabled;
            this.signatureGenerator = signatureGenerator;
            this.compressorEntryPoint = compressorEntryPoint;
        }

        @Override
        public void close() throws Exception {
            if (this.enabled) {
                this.signatureGenerator.generate().encode(this.compressorEntryPoint);
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public PGPSignatureGenerator getSignatureGenerator() {
            return this.signatureGenerator;
        }
    }

    private class NullSignatureGeneratorClosable
    extends SignatureGeneratorClosable {
        private NullSignatureGeneratorClosable() {
            super(false, null, null);
        }
    }
}

