/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.jce;

import com.mulesoft.modules.cryptography.api.jce.config.JceAsymmetricKeyInfo;
import com.mulesoft.modules.cryptography.api.jce.config.JceEncryptionPbeAlgorithm;
import com.mulesoft.modules.cryptography.api.jce.config.JceKeyInfo;
import com.mulesoft.modules.cryptography.api.jce.config.JceSignatureKeyAlgorithm;
import com.mulesoft.modules.cryptography.api.jce.config.JceSignaturePbeAlgorithm;
import com.mulesoft.modules.cryptography.api.jce.config.JceSymmetricKeyInfo;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.errors.DecryptionErrorTypeProvider;
import com.mulesoft.modules.cryptography.internal.errors.EncryptionErrorTypeProvider;
import com.mulesoft.modules.cryptography.internal.errors.ParametersErrorTypeProvider;
import com.mulesoft.modules.cryptography.internal.errors.SignatureErrorTypeProvider;
import com.mulesoft.modules.cryptography.internal.errors.ValidationErrorTypeProvider;
import com.mulesoft.modules.cryptography.internal.jce.config.JceConfiguration;
import com.mulesoft.modules.cryptography.internal.jce.config.JceEncryptionKeyAlgorithmSelection;
import com.mulesoft.modules.cryptography.internal.jce.config.JceKeySelection;
import com.mulesoft.modules.cryptography.internal.jce.impl.JceAsymmetricKeyImpl;
import com.mulesoft.modules.cryptography.internal.jce.impl.JceKeyImpl;
import com.mulesoft.modules.cryptography.internal.jce.impl.JcePbeImpl;
import com.mulesoft.modules.cryptography.internal.jce.impl.JceSymmetricKeyImpl;
import java.io.InputStream;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.stereotype.Validator;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class JceOperations {
    @MediaType(value="application/octet-stream", strict=false)
    @Throws(value={EncryptionErrorTypeProvider.class, ParametersErrorTypeProvider.class})
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public InputStream jceEncrypt(@Config JceConfiguration config, @Content InputStream content, @ParameterGroup(name="Algorithm selection") JceEncryptionKeyAlgorithmSelection algorithmSelection, @ParameterGroup(name="Key selection") JceKeySelection keySelection) {
        return this.createKeyImplFor(config, keySelection.getKeyInfo(config)).encrypt(content, algorithmSelection.getCipher());
    }

    @MediaType(value="application/octet-stream", strict=false)
    @Throws(value={DecryptionErrorTypeProvider.class, ParametersErrorTypeProvider.class})
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public InputStream jceDecrypt(@Config JceConfiguration config, @Content InputStream content, @ParameterGroup(name="Algorithm selection") JceEncryptionKeyAlgorithmSelection algorithmSelection, @ParameterGroup(name="Key selection") JceKeySelection keySelection) {
        return this.createKeyImplFor(config, keySelection.getKeyInfo(config)).decrypt(content, algorithmSelection.getCipher());
    }

    @MediaType(value="text/plain", strict=false)
    @Throws(value={SignatureErrorTypeProvider.class})
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public String jceSign(@Config JceConfiguration config, @Content InputStream content, @Optional(defaultValue="HmacSHA256") JceSignatureKeyAlgorithm algorithm, @ParameterGroup(name="Key selection") JceKeySelection keySelection) {
        return this.createKeyImplFor(config, keySelection.getKeyInfo(config)).sign(content, algorithm.name());
    }

    @Validator
    @Throws(value={ValidationErrorTypeProvider.class})
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public void jceValidate(@Config JceConfiguration config, @Optional(defaultValue="#[payload]") InputStream value, String expected, @Optional(defaultValue="HmacSHA256") JceSignatureKeyAlgorithm algorithm, @ParameterGroup(name="Key selection") JceKeySelection keySelection) {
        boolean isVerified = this.createKeyImplFor(config, keySelection.getKeyInfo(config)).validate(value, expected, algorithm.name());
        if (!isVerified) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"JCE signature verification failed"), (ErrorTypeDefinition)CryptoErrors.VALIDATION);
        }
    }

    @MediaType(value="application/octet-stream", strict=false)
    @Throws(value={EncryptionErrorTypeProvider.class, ParametersErrorTypeProvider.class})
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public InputStream jceEncryptPbe(@Content InputStream content, @Optional(defaultValue="PBEWithHmacSHA256AndAES_128") JceEncryptionPbeAlgorithm algorithm, @Password String password) {
        return new JcePbeImpl(password).encrypt(content, algorithm.name());
    }

    @MediaType(value="application/octet-stream", strict=false)
    @Throws(value={DecryptionErrorTypeProvider.class, ParametersErrorTypeProvider.class})
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public InputStream jceDecryptPbe(@Content InputStream content, @Optional(defaultValue="PBEWithHmacSHA256AndAES_128") JceEncryptionPbeAlgorithm algorithm, @Password String password) {
        return new JcePbeImpl(password).decrypt(content, algorithm.name());
    }

    @MediaType(value="text/plain", strict=false)
    @Throws(value={SignatureErrorTypeProvider.class})
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public String jceSignPbe(@Content InputStream content, @Optional(defaultValue="PBEWithHmacSHA256") JceSignaturePbeAlgorithm algorithm, @Password String password) {
        return new JcePbeImpl(password).sign(content, algorithm.name());
    }

    @Validator
    @Throws(value={ValidationErrorTypeProvider.class})
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public void jceValidatePbe(@Optional(defaultValue="#[payload]") InputStream value, String expected, @Optional(defaultValue="PBEWithHmacSHA256") JceSignaturePbeAlgorithm algorithm, @Password String password) {
        boolean isVerified = new JcePbeImpl(password).validate(value, expected, algorithm.name());
        if (!isVerified) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"JCE signature verification failed"), (ErrorTypeDefinition)CryptoErrors.VALIDATION);
        }
    }

    private JceKeyImpl createKeyImplFor(JceConfiguration config, JceKeyInfo keyInfo) {
        if (keyInfo.isSymmetric()) {
            return new JceSymmetricKeyImpl(config, (JceSymmetricKeyInfo)keyInfo);
        }
        return new JceAsymmetricKeyImpl(config, (JceAsymmetricKeyInfo)keyInfo);
    }
}

